/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ovopark.messagehub.kernel.service.UsersService;
import com.ovopark.privilege.api.UserApi;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.privilege.response.BaseResult;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UsersServiceImpl
implements UsersService {
    private static final Logger log = LoggerFactory.getLogger(UsersServiceImpl.class);
    @Resource
    private UserApi userApi;

    @Override
    public List<UsersPojo> getUserByIdList(List<Integer> ids) {
        log.info("getUserByIdList ids:{}", ids);
        BaseResult getUserByIdList = this.userApi.getUsersListPostByIds(ids);
        log.info("getUserByIdList getUserByIdList:{}", (Object)JSONObject.toJSONString((Object)getUserByIdList));
        if (getUserByIdList != null && getUserByIdList.getData() != null) {
            return (List)getUserByIdList.getData();
        }
        return Lists.newArrayList();
    }

    @Override
    public UsersPojo getUserById(Integer id) {
        log.info("getUserById id:{}", (Object)id);
        BaseResult getUserById = this.userApi.getUsersById(id);
        log.info("getUserById:{}", (Object)getUserById);
        if (getUserById != null && getUserById.getData() != null) {
            return (UsersPojo)getUserById.getData();
        }
        return null;
    }

    @Override
    public UsersPojo getUserByUserName(String userName) {
        log.info("getUserByUserName userName:{}", (Object)userName);
        BaseResult getUsersByUserName = this.userApi.getUserByUserName(userName);
        log.info("getUsersByUserName:{}", (Object)getUsersByUserName);
        if (getUsersByUserName != null && getUsersByUserName.getData() != null) {
            return (UsersPojo)getUsersByUserName.getData();
        }
        return null;
    }

    @Override
    public UsersPojo getUserByPhone(Integer groupId, String mobilePhone, String nationalCode) {
        log.info("getUserByPhone mobilePhone:{}", (Object)mobilePhone);
        BaseResult getUserByPhone = this.userApi.getUserByPhone(groupId, mobilePhone, nationalCode);
        log.info("getUserByPhone:{}", (Object)getUserByPhone);
        if (getUserByPhone != null && getUserByPhone.getData() != null) {
            return (UsersPojo)getUserByPhone.getData();
        }
        return null;
    }

    @Override
    public UsersPojo getUserByEmployeeNumber(Integer groupId, String employeeNumber) {
        log.info("getUserByEmployeeNumber employeeNumber:{}", (Object)employeeNumber);
        BaseResult getUserByEmployeeNumber = this.userApi.getUserByEmployeeNumber(groupId, employeeNumber);
        log.info("getUserByEmployeeNumber:{}", (Object)getUserByEmployeeNumber);
        if (getUserByEmployeeNumber != null && getUserByEmployeeNumber.getData() != null) {
            return (UsersPojo)getUserByEmployeeNumber.getData();
        }
        return null;
    }
}

