/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.UserMsgPositionService;
import com.ovopark.messagehub.kernel.model.es.UserMsgPosition;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleUserMsgPositionService
implements UserMsgPositionService {
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private DefMsgCfService defMsgCfService;
    private static UserMsgPositionService.UserMsgPositionReadService userMsgPositionReadService;

    @PostConstruct
    private void post() {
        userMsgPositionReadService = new UserMsgPositionService.UserMsgPositionReadService(this.elasticsearchOperations, this.defMsgCfService);
    }

    @Override
    public List<UserMsgPosition.Position> position(int userId, List<String> codeList) {
        return userMsgPositionReadService.position(userId, codeList, 1);
    }

    @Override
    public void upsertDeletePosition(int userId, long ckTimeMs, List<String> msgCodeList) {
        if (Util.isEmpty(msgCodeList)) {
            return;
        }
        UserMsgPosition userMsgPosition = (UserMsgPosition)this.elasticsearchOperations.get(UserMsgPosition.INDEX, String.valueOf(userId), UserMsgPosition.class);
        if (userMsgPosition == null) {
            userMsgPosition = new UserMsgPosition();
            userMsgPosition.setMsgTypePosition(new HashMap<String, UserMsgPosition.Position>());
        }
        if (Util.isNotEmpty(msgCodeList)) {
            for (String code : msgCodeList) {
                UserMsgPosition.Position position = userMsgPosition.getMsgTypePosition().get(code);
                if (position == null) {
                    position = new UserMsgPosition.Position();
                    position.setCode(code);
                }
                position.setDeletePositionMs(ckTimeMs);
                userMsgPosition.getMsgTypePosition().put(code, position);
            }
        }
        userMsgPosition.setId(String.valueOf(userId));
        userMsgPosition.setTime(LocalDateTime.now());
        this.elasticsearchOperations.upsert(UserMsgPosition.INDEX, (Document)userMsgPosition);
    }

    @Override
    public void upsertReadPosition(int userId, long ckTimeMs, List<String> msgCodeList) {
        if (Util.isEmpty(msgCodeList)) {
            return;
        }
        UserMsgPosition userMsgPosition = (UserMsgPosition)this.elasticsearchOperations.get(UserMsgPosition.INDEX, String.valueOf(userId), UserMsgPosition.class);
        if (userMsgPosition == null) {
            userMsgPosition = new UserMsgPosition();
            userMsgPosition.setMsgTypePosition(new HashMap<String, UserMsgPosition.Position>());
        }
        if (Util.isNotEmpty(msgCodeList)) {
            for (String code : msgCodeList) {
                UserMsgPosition.Position position = userMsgPosition.getMsgTypePosition().get(code);
                if (position == null) {
                    position = new UserMsgPosition.Position();
                    position.setCode(code);
                }
                position.setReadPositionMs(ckTimeMs);
                userMsgPosition.getMsgTypePosition().put(code, position);
            }
        }
        userMsgPosition.setId(String.valueOf(userId));
        userMsgPosition.setTime(LocalDateTime.now());
        this.elasticsearchOperations.upsert(UserMsgPosition.INDEX, (Document)userMsgPosition);
    }
}

