/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.messagehub.kernel.common.utils.RedisUtil;
import com.ovopark.messagehub.kernel.model.mo.MessageMo;
import com.ovopark.messagehub.kernel.model.pojo.EcovacsMessage;
import com.ovopark.messagehub.kernel.model.vo.RedisVo;
import com.ovopark.messagehub.kernel.model.vo.TokenVo;
import com.ovopark.messagehub.kernel.service.DepartmentsService;
import com.ovopark.messagehub.kernel.service.UsersService;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.privilege.pojo.UsersPojo;
import jakarta.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EcovacsUtil {
    private static final Logger log = LoggerFactory.getLogger(EcovacsUtil.class);
    @Value(value="${ecovacs.appKey}")
    private String appKey;
    @Value(value="${ecovacs.appSecret}")
    private String appSecret;
    @Value(value="${ecovacs.url}")
    private String url;
    @Value(value="${ecovacs.messageBaseUrl}")
    private String messageBaseUrl;
    @Value(value="${ecovacs.groupId}")
    private Integer groupId;
    @Value(value="${ecovacs.userName}")
    private String userName;
    @Value(value="${ecovacs.password}")
    private String password;
    @Resource
    private UsersService userService;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private DepartmentsService departmentsService;
    private static final String MESSAGE_URI = "restcloud/store_open_api/storeInfoOpen/pushOvoparkMsg";

    public void sendMessage(MessageMo todoMessage) {
        if (this.groupId == null) {
            return;
        }
        if (todoMessage.getEnterpriseId() == null || !todoMessage.getEnterpriseId().equals(this.groupId)) {
            return;
        }
        if (todoMessage.getObjectType().equals("Problem_Capture_Notify") || todoMessage.getObjectType().equals("Problem_FeedBack_Notify") || todoMessage.getObjectType().equals("TEMP_CHECK_REPORT_NOTIFY") || todoMessage.getObjectType().equals("FINAL_CHECK_REPORT_NOTIFY") || todoMessage.getCategory().equals("TYPE_STORE_PLAN_SYSTEM") || todoMessage.getCategory().equals("FINAL_CHECK_REPORT") && (todoMessage.getObjectType().equals("CHECK_TASK_REMIND_NOTIFY") || todoMessage.getObjectType().equals("REPORT_COMMENT_NOTIFY")) || todoMessage.getCategory().equals("CHECK_REPORT_SUBSCRIPTION") && (todoMessage.getObjectType().equals("CHECK_REPORT_SUBSCRIPTION_NOTIFY") || todoMessage.getObjectType().equals("CHECK_REPORT_REAL_TIME_NOTIFY")) || todoMessage.getCategory().equals("TYPE_BIRD_DETECT") && (todoMessage.getObjectType().equals("REPORT_WAIT_CHECK") || todoMessage.getObjectType().equals("REPORT_CHECK_PASS"))) {
            if (todoMessage.getCategory().equals("TYPE_STORE_PLAN_SYSTEM") && (todoMessage.getObjectType().equals("\u5de1\u68c0\u8ba1\u5212") && (todoMessage.getObjectId().toString().equals("0") || todoMessage.getObjectId().toString().equals("2")) || todoMessage.getObjectType().equals("INPECTION_PLAN") && (todoMessage.getObjectId().toString().equals("0") || todoMessage.getObjectId().toString().equals("2")))) {
                return;
            }
            this.sendMessage0(todoMessage);
        }
    }

    public void sendMessageNew(MessageMo todoMessage) {
        this.sendMessage0(todoMessage);
    }

    private void sendMessage0(MessageMo todoMessage) {
        Long staffId = this.getEcovacsUserId(todoMessage.getTargetUserId());
        String messageUri = this.getUri(todoMessage);
        if (staffId != null && StringUtils.isNotEmpty((String)messageUri)) {
            HashMap params = new HashMap();
            EcovacsMessage message = new EcovacsMessage();
            message.setMsgSubject(this.getMessageSubject(todoMessage));
            message.setMsgBody(todoMessage.getContent());
            message.setUserId(staffId);
            message.setDetailUrl(this.messageBaseUrl + messageUri);
            message.setRelationId(todoMessage.getId());
            if (message.getRelationId() == null) {
                message.setRelationId(0L);
            }
            String identitytoken = this.getToken();
            log.info("send post to:" + this.url + "restcloud/store_open_api/storeInfoOpen/pushOvoparkMsg;message:" + JSON.toJSONString((Object)message) + "; params:" + JSON.toJSONString(params) + ";identitytoken:" + identitytoken);
            StringBuilder messageUrl = new StringBuilder(this.url + MESSAGE_URI);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("identitytoken", identitytoken);
            HttpEntity request = new HttpEntity((Object)JSON.toJSONString((Object)message), (MultiValueMap)headers);
            String response = (String)this.restTemplate.postForObject(messageUrl.toString(), (Object)request, String.class, params);
            log.info("get result:" + response);
        } else {
            log.info("not ecovacs staff. userId:" + todoMessage.getTargetUserId());
        }
    }

    private String getMessageSubject(MessageMo message) {
        String subjectName = "";
        switch (message.getObjectType()) {
            case "Problem_Capture_Notify": 
            case "Problem_FeedBack_Notify": {
                subjectName = "\u5f85\u529e\u5355";
                break;
            }
            case "TEMP_CHECK_REPORT_NOTIFY": {
                subjectName = "\u5de1\u5e97\u5ba1\u6838";
                break;
            }
            case "FINAL_CHECK_REPORT_NOTIFY": {
                subjectName = "\u5de1\u5e97\u8bb0\u5f55";
                break;
            }
            case "TYPE_STORE_PLAN_SYSTEM": {
                subjectName = "\u8ba1\u5212\u5de1\u5e97";
            }
        }
        switch (message.getCategory()) {
            case "TYPE_STORE_PLAN_SYSTEM": {
                subjectName = "\u8ba1\u5212\u5de1\u5e97";
                break;
            }
            case "CHECK_REPORT_SUBSCRIPTION": {
                subjectName = "\u5de1\u5e97\u62a5\u544a";
                break;
            }
            case "FINAL_CHECK_REPORT": {
                String ObjectTypeAndMainType;
                if (message.getObjectType().equals("REPORT_COMMENT_NOTIFY")) {
                    subjectName = "\u5de1\u5e97\u8bc4\u8bba";
                    break;
                }
                switch (ObjectTypeAndMainType = message.getObjectType() + message.getMainType()) {
                    case "CHECK_TASK_REMIND_NOTIFY0": {
                        subjectName = "\u73b0\u573a\u5de1\u5e97";
                        break;
                    }
                    case "CHECK_TASK_REMIND_NOTIFY1": {
                        subjectName = "\u8fdc\u7a0b\u5de1\u5e97";
                        break;
                    }
                    case "CHECK_TASK_REMIND_NOTIFY12": {
                        subjectName = "\u95e8\u5e97\u81ea\u68c0";
                    }
                }
                break;
            }
            case "TYPE_BIRD_DETECT": {
                subjectName = "\u6697\u8bbf\u62a5\u544a";
            }
        }
        return subjectName;
    }

    private Long getEcovacsUserId(Integer userId) {
        UsersPojo users = this.userService.getUserById(userId);
        if (users != null && users.getIsDel() == 0 && users.getIsFrozen() == 0 && users.getUserName().contains("ECOVACS_STAFF_")) {
            return Long.parseLong(users.getUserName().replaceAll("ECOVACS_STAFF_", ""));
        }
        return null;
    }

    private String getToken() {
        String token = "";
        String key = RedisVo.KWS_TOKEN;
        String object = (String)this.redisUtil.get(key);
        token = StringUtils.isEmpty((String)object) ? this.getRequestToken(object) : object;
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized String getRequestToken(String token) {
        String key = RedisVo.KWS_TOKEN;
        String object = (String)this.redisUtil.get(key);
        if (!StringUtils.isEmpty((String)object)) return object;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userName", this.userName);
        paramMap.put("password", this.password);
        String result = (String)this.restTemplate.postForObject(this.url + "restcloud/rest/core/auth/login", null, String.class, paramMap);
        log.info("getEcovacsToken:" + result);
        TokenVo mo = (TokenVo)JSONObject.parseObject((String)result, TokenVo.class);
        if (mo == null || !mo.getState().booleanValue()) {
            log.info("auth/login \u83b7\u53d6token\uff1a" + result);
            throw new RuntimeException("auth/login \u83b7\u53d6token\u5931\u8d25");
        }
        token = mo.getIdentitytoken();
        this.redisUtil.set(key, token, 1L, TimeUnit.HOURS);
        return token;
    }

    private String getUri(MessageMo message) {
        Object uri = null;
        switch (message.getObjectType()) {
            case "Problem_Capture_Notify": 
            case "Problem_FeedBack_Notify": {
                uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=problemDetails&problemId=" + message.getObjectId();
                break;
            }
            case "TEMP_CHECK_REPORT_NOTIFY": {
                uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=inspectionExamine&liveTaskId=&messageId=" + message.getObjectIds() + "&userId=" + message.getTargetUserId() + "&reWriteGroupId=" + message.getEnterpriseId();
                break;
            }
            case "FINAL_CHECK_REPORT_NOTIFY": {
                uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=inspectionRecordDetail&historyId=&messageId=" + message.getObjectIds() + "&reWriteGroupId=" + message.getEnterpriseId();
                break;
            }
            case "TYPE_STORE_PLAN_SYSTEM": {
                uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=planCheckTaskDetail&qw=1&id=" + message.getSubId() + "&mainType=" + message.getMainType();
            }
        }
        block20 : switch (message.getCategory()) {
            case "TYPE_STORE_PLAN_SYSTEM": {
                uri = EcovacsUtil.storePlanUrl(message.getObjectType(), message.getObjectId(), message.getEnterpriseId(), message.getSubId(), message.getMainType(), message.getDetails());
                break;
            }
            case "CHECK_REPORT_SUBSCRIPTION": {
                switch (message.getObjectType()) {
                    case "CHECK_REPORT_SUBSCRIPTION_NOTIFY": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=inspectionReportDetail&reportMsgId=" + message.getObjectId() + "&userId=" + message.getTargetUserId() + "&reWriteGroupId=" + message.getEnterpriseId();
                        break;
                    }
                    case "CHECK_REPORT_REAL_TIME_NOTIFY": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=inspectionRecordDetail&historyId=" + message.getObjectId() + "&messageId=&reWriteGroupId=" + message.getEnterpriseId();
                    }
                }
                break;
            }
            case "FINAL_CHECK_REPORT": {
                if (message.getObjectType().equals("REPORT_COMMENT_NOTIFY")) {
                    uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=inspectionRecordDetail&historyId=" + message.getObjectId() + "&messageId=&reWriteGroupId=" + message.getEnterpriseId();
                    break;
                }
                String ObjectTypeAndMainType = message.getObjectType() + message.getMainType();
                DepartmentPojo dep = null;
                String departmentName = "";
                if (message.getDepartmentId() != null && (dep = this.departmentsService.getDepartmentById(message.getDepartmentId())) != null) {
                    try {
                        departmentName = URLEncoder.encode(dep.getName(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        log.info("URLEncoder error. departmentName:" + departmentName);
                    }
                }
                Integer source = 0;
                String planTaskId = "";
                String expandId = "";
                if (StringUtils.isNotEmpty((String)message.getJsonText())) {
                    Integer expandIdIn;
                    Integer planTaskIdIn;
                    Map object = (Map)JSON.parse((String)message.getJsonText());
                    if (object.get("pid") != null && (planTaskIdIn = (Integer)object.get("pid")) != null) {
                        planTaskId = planTaskIdIn.toString();
                    }
                    if (object.get("source") != null) {
                        source = (Integer)object.get("source");
                    }
                    if (object.get("expandId") != null && (expandIdIn = (Integer)object.get("expandId")) != null) {
                        expandId = expandIdIn.toString();
                    }
                }
                String longitudeStr = "";
                if (dep != null && dep.getLongitude() != null) {
                    longitudeStr = dep.getLongitude().toString();
                }
                String latitudeStr = "";
                if (dep != null && dep.getLatitude() != null) {
                    latitudeStr = dep.getLatitude().toString();
                }
                switch (ObjectTypeAndMainType) {
                    case "CHECK_TASK_REMIND_NOTIFY0": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=shopInspect&goon=1&taskId=" + message.getObjectId() + "&depId=" + message.getDepartmentId() + "&depName=" + departmentName + "&longitude=" + longitudeStr + "&latitude=" + latitudeStr;
                        if (source <= 0) break;
                        uri = (String)uri + "&planTaskId=" + planTaskId + "&storePlanDetailId=" + expandId;
                        break;
                    }
                    case "CHECK_TASK_REMIND_NOTIFY1": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=remoteInspect&goon=1&taskId=" + message.getObjectId() + "&depId=" + message.getDepartmentId() + "&depName=" + departmentName;
                        if (source <= 0) break;
                        uri = (String)uri + "&planTaskId=" + planTaskId + "&storePlanDetailId=" + expandId;
                        break;
                    }
                    case "CHECK_TASK_REMIND_NOTIFY12": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + message.getEnterpriseId() + "&redirectType=selfInspect&goon=1&taskId=" + message.getObjectId() + "&depId=" + message.getDepartmentId() + "&depName=" + departmentName + "&longitude=" + longitudeStr + "&latitude=" + latitudeStr;
                        if (source <= 0) break;
                        uri = (String)uri + "&planTaskId=" + planTaskId + "&storePlanDetailId=" + expandId;
                    }
                }
                break;
            }
            case "TYPE_BIRD_DETECT": {
                switch (message.getObjectType()) {
                    case "REPORT_WAIT_CHECK": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + this.groupId + "&redirectType=storeReport";
                        break block20;
                    }
                    case "REPORT_CHECK_PASS": {
                        uri = "/webview/h5base/index.html/oauth?groupId=" + this.groupId + "&redirectType=storeReportDetail&userTaskId=" + message.getObjectId() + "&currentId=1";
                    }
                }
            }
        }
        return uri;
    }

    private String createSign(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(params);
        for (Map.Entry entry : sortParams.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if ("authAppkey".equals(key) || StringUtils.isEmpty((String)(value = entry.getValue().toString().trim()))) continue;
            sb.append(key).append("=").append(value);
        }
        String stringSignTemp = this.appKey + sb.toString() + this.appSecret;
        log.info("original encrypt content:" + stringSignTemp);
        String signValue = DigestUtils.md5Hex((String)stringSignTemp);
        log.info("stringA+privateKey\u540eMD5\u52a0\u5bc6\u751f\u6210sign\u4e3a\uff1a       " + signValue);
        return signValue;
    }

    private static String storePlanUrl(String objectType, Integer objectId, Integer groupId, Integer subId, Integer mainType, String detail) {
        Object url = "";
        if (objectType.equals("INSPECTION_PLAN")) {
            Integer type = objectId;
            switch (type) {
                case 0: {
                    url = "";
                    break;
                }
                case 1: {
                    url = "/webview/h5base/index.html/oauth?groupId=" + groupId + "&redirectType=patrolInspectionDetail&mainType=17&taskId=" + subId;
                    break;
                }
                case 2: {
                    url = "";
                    break;
                }
                case 3: {
                    url = "/webview/h5base/index.html/oauth?groupId=" + groupId + "&redirectType=patrolInspectionDetail&mainType=17&taskId=" + subId;
                }
            }
        } else if (objectType.equals("CHECK_AUDIT")) {
            Map object;
            Integer id = null;
            if (StringUtils.isNotEmpty((String)detail) && (object = (Map)JSON.parse((String)detail)).get("auditDetailId") != null) {
                id = (Integer)object.get("auditDetailId");
            }
            if (id != null) {
                url = "/webview/h5base/index.html/oauth?id=" + id + "&currentTab=1&groupId=" + groupId + "&redirectType=planCheckTaskReview&qw=1";
            }
        } else {
            url = "/webview/h5base/index.html/oauth?groupId=" + groupId + "&redirectType=planCheckTaskDetail&qw=1&id=" + subId + "&mainType=" + mainType;
        }
        return url;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMessageBaseUrl() {
        return this.messageBaseUrl;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public UsersService getUserService() {
        return this.userService;
    }

    public RedisUtil getRedisUtil() {
        return this.redisUtil;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public DepartmentsService getDepartmentsService() {
        return this.departmentsService;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMessageBaseUrl(String messageBaseUrl) {
        this.messageBaseUrl = messageBaseUrl;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserService(UsersService userService) {
        this.userService = userService;
    }

    public void setRedisUtil(RedisUtil redisUtil) {
        this.redisUtil = redisUtil;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setDepartmentsService(DepartmentsService departmentsService) {
        this.departmentsService = departmentsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EcovacsUtil)) {
            return false;
        }
        EcovacsUtil other = (EcovacsUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$groupId = this.getGroupId();
        Integer other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$messageBaseUrl = this.getMessageBaseUrl();
        String other$messageBaseUrl = other.getMessageBaseUrl();
        if (this$messageBaseUrl == null ? other$messageBaseUrl != null : !this$messageBaseUrl.equals(other$messageBaseUrl)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        UsersService this$userService = this.getUserService();
        UsersService other$userService = other.getUserService();
        if (this$userService == null ? other$userService != null : !this$userService.equals(other$userService)) {
            return false;
        }
        RedisUtil this$redisUtil = this.getRedisUtil();
        RedisUtil other$redisUtil = other.getRedisUtil();
        if (this$redisUtil == null ? other$redisUtil != null : !this$redisUtil.equals(other$redisUtil)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        DepartmentsService this$departmentsService = this.getDepartmentsService();
        DepartmentsService other$departmentsService = other.getDepartmentsService();
        return !(this$departmentsService == null ? other$departmentsService != null : !this$departmentsService.equals(other$departmentsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EcovacsUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $messageBaseUrl = this.getMessageBaseUrl();
        result = result * 59 + ($messageBaseUrl == null ? 43 : $messageBaseUrl.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        UsersService $userService = this.getUserService();
        result = result * 59 + ($userService == null ? 43 : $userService.hashCode());
        RedisUtil $redisUtil = this.getRedisUtil();
        result = result * 59 + ($redisUtil == null ? 43 : $redisUtil.hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        DepartmentsService $departmentsService = this.getDepartmentsService();
        result = result * 59 + ($departmentsService == null ? 43 : $departmentsService.hashCode());
        return result;
    }

    public String toString() {
        return "EcovacsUtil(appKey=" + this.getAppKey() + ", appSecret=" + this.getAppSecret() + ", url=" + this.getUrl() + ", messageBaseUrl=" + this.getMessageBaseUrl() + ", groupId=" + this.getGroupId() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", userService=" + String.valueOf(this.getUserService()) + ", redisUtil=" + String.valueOf(this.getRedisUtil()) + ", restTemplate=" + String.valueOf(this.getRestTemplate()) + ", departmentsService=" + String.valueOf(this.getDepartmentsService()) + ")";
    }
}

