/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.service.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.DefTodoMsgCfService;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.TagCodec;
import com.ovopark.messagehub.kernel.TodoMsgService;
import com.ovopark.messagehub.kernel.UserEventNotify;
import com.ovopark.messagehub.kernel.mapper.TodoMessageHistoryMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMessageMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMsgEventTraceMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMsgExtMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMsgIdMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMsgTagMapper;
import com.ovopark.messagehub.kernel.model.entity.TodoMessage;
import com.ovopark.messagehub.kernel.model.entity.TodoMessageHistory;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgEventTrace;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgExt;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgId;
import com.ovopark.messagehub.kernel.model.entity.TodoMsgTag;
import com.ovopark.messagehub.kernel.model.vo.TodoMessageGroupVo;
import com.ovopark.messagehub.kernel.service.DeleteExpiredTodoMsgDelayTaskService;
import com.ovopark.messagehub.kernel.service.TodoMsgServiceV2;
import com.ovopark.messagehub.kernel.service.TodoMsgTagService;
import com.ovopark.messagehub.kernel.service.impl.TodoMessageServiceImpl;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.internal.MessageHubInteractApi;
import com.ovopark.messagehub.sdk.model.OneTodoMessageSaveRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageGetResponse;
import com.ovopark.messagehub.sdk.model.TodoMessageSaveRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageTrait;
import com.ovopark.messagehub.sdk.model.internal.DeleteTodoMessageModel;
import com.ovopark.module.shared.AsyncTaskService;
import com.ovopark.module.shared.Session;
import com.ovopark.utils.DateUtils;
import jakarta.annotation.Resource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodoMsgServiceV2Impl
implements TodoMsgServiceV2 {
    private static final Logger log = LoggerFactory.getLogger(TodoMsgServiceV2Impl.class);
    @Resource
    private TodoMessageMapper todoMessageMapper;
    @Autowired
    private TodoMsgEventTraceMapper todoMsgEventTraceMapper;
    @Autowired
    private TodoMsgExtMapper todoMsgExtMapper;
    @Resource
    private MessageHubV2Api messageHubV2Api;
    @Autowired
    private AsyncTaskService asyncTaskService;
    @Autowired
    private TodoMessageServiceImpl todoMessageService;
    @Autowired
    private UserEventNotify userEventNotify;
    @Autowired
    private TodoMsgIdMapper todoMsgIdMapper;
    @Resource
    private TodoMessageHistoryMapper todoMessageHistoryMapper;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Autowired
    private DeleteExpiredTodoMsgDelayTaskService deleteExpiredTodoMsgDelayTaskService;
    @Autowired
    private MessageHubInteractApi messageHubInteractApi;
    @Autowired
    private TodoMsgTagService todoMsgTagService;
    @Autowired
    private TodoMsgTagMapper todoMsgTagMapper;
    @Autowired
    private DefTodoMsgCfService defTodoMsgCfService;
    @Resource
    private MessageSource messageSource;

    @Override
    public boolean deleteTodoMessages(Long id, Integer status) {
        try {
            if (id == null) {
                return false;
            }
            if (status != null) {
                TodoMessage todoMessage = new TodoMessage();
                if (status == 1) {
                    TodoMessageHistory todoMessageHistory = this.getCompleteTodoMessageById(id);
                    if (todoMessageHistory == null) {
                        return false;
                    }
                    todoMessage = new TodoMessage();
                    BeanUtils.copyProperties((Object)todoMessageHistory, (Object)todoMessage);
                    this.todoMessageHistoryMapper.deleteById(id);
                } else {
                    todoMessage = this.getTodoMessageById(id);
                    if (todoMessage == null) {
                        return false;
                    }
                    this.todoMessageMapper.deleteById(id);
                }
                todoMessage.setDeleteTime(LocalDateTime.now());
                this.todoMessageMapper.batchSaveTodoMessagesDelByObject(List.of(todoMessage));
                return true;
            }
        }
        catch (Exception e) {
            log.error("deleteTodoMessages error", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public boolean batchDeleteTodoMessages(List<DeleteTodoMessageModel> moList) {
        if (CollectionUtils.isEmpty(moList)) {
            return false;
        }
        try {
            List<TodoMessage> list;
            List<TodoMessageHistory> todoMessageHistoryList;
            ArrayList todoMessageList = Lists.newArrayList();
            Map map = moList.stream().collect(Collectors.groupingBy(DeleteTodoMessageModel::getStatus, Collectors.mapping(DeleteTodoMessageModel::getId, Collectors.toList())));
            List<Long> completeList = map.get(1);
            if (CollectionUtils.isNotEmpty(completeList) && CollectionUtils.isNotEmpty(todoMessageHistoryList = this.batchGetCompleteTodoMessageById(completeList))) {
                this.todoMessageHistoryMapper.deleteBatchIds(completeList);
                for (TodoMessageHistory todoMessageHistory : todoMessageHistoryList) {
                    TodoMessage todoMessage = new TodoMessage();
                    BeanUtils.copyProperties((Object)todoMessageHistory, (Object)todoMessage);
                    todoMessage.setDeleteTime(LocalDateTime.now());
                    todoMessageList.add(todoMessage);
                }
            }
            ArrayList otherList = Lists.newArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == 1) continue;
                otherList.addAll(entry.getValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)otherList) && CollectionUtils.isNotEmpty(list = this.batchGetTodoMessageById(otherList))) {
                for (TodoMessage todoMessage : list) {
                    todoMessage.setDeleteTime(LocalDateTime.now());
                }
                this.todoMessageMapper.deleteBatchIds(otherList);
                todoMessageList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty((Collection)todoMessageList)) {
                this.todoMessageMapper.batchSaveTodoMessagesDelByObject(todoMessageList);
                for (TodoMessage todoMessage : todoMessageList) {
                    this.userEventNotify.notifyUserOnTodoMsg(todoMessage.getTargetUserId(), todoMessage.getEnterpriseId(), todoMessage.getId(), UserEventNotify.Operation.DELETE);
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error("batchDeleteTodoMessages error", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public TodoMessageGetResponse getMessages(String objectType, Integer objectId) {
        int limit = 1000;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        queryWrapper.orderByAsc(TodoMessage::getId);
        queryWrapper.last(" limit 0 , 1000");
        List list = this.todoMessageMapper.selectList((Wrapper)queryWrapper);
        TodoMessageGetResponse todoMessageGetResponse = new TodoMessageGetResponse();
        todoMessageGetResponse.setExist(Util.isNotEmpty((Collection)list));
        todoMessageGetResponse.setMatchAll(list.size() < 1000);
        todoMessageGetResponse.setTodoMsgResponseModelList(list.stream().map(todoMessage -> {
            TodoMessageTrait.TodoMsgResponseModel t = new TodoMessageTrait.TodoMsgResponseModel();
            BeanUtils.copyProperties((Object)todoMessage, (Object)t);
            return t;
        }).toList());
        return todoMessageGetResponse;
    }

    @Override
    public long count(Integer userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getStatus, (Object)0);
        queryWrapper.eq(TodoMessage::getIsRecommend, (Object)0);
        queryWrapper.eq(TodoMessage::getTargetUserId, (Object)userId);
        queryWrapper.isNotNull(TodoMessage::getEnterpriseId);
        List<String> categoryList = this.defTodoMsgCfService.group("ALL");
        if (Util.isNotEmpty(categoryList)) {
            queryWrapper.in(TodoMessage::getCategory, categoryList);
        }
        Long l = this.todoMessageMapper.selectCount((Wrapper)queryWrapper);
        return Optional.ofNullable(l).orElse(0L);
    }

    @Override
    public IPage<TodoMessage> getTodoMessages(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer status, Integer isRecommend, String createTimeStart, String createTimeEnd) {
        if (status != null && status == 1) {
            return this.getCompleteTodoMessages(userId, enterpriseId, pageNumber, pageSize, categoryList, isExecutor, sort, endTimeStart, endTimeEnd, isRecommend, createTimeStart, createTimeEnd);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"target_user_id", (Object)userId);
        if (enterpriseId != null) {
            queryWrapper.eq((Object)"enterprise_id", (Object)enterpriseId);
        } else {
            queryWrapper.isNull((Object)"enterprise_id");
        }
        if (isExecutor != null) {
            queryWrapper.eq((Object)"is_executor", (Object)isExecutor);
        }
        if (isRecommend != null) {
            queryWrapper.eq((Object)"is_recommend", (Object)isRecommend);
        }
        if (CollectionUtils.isNotEmpty(categoryList)) {
            queryWrapper.in((Object)"category", categoryList);
        }
        if (StringUtils.isNotEmpty((String)endTimeStart)) {
            queryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.ge((Object)"end_time", (Object)endTimeStart)).or()).isNull((Object)"end_time"));
        }
        if (StringUtils.isNotEmpty((String)endTimeEnd)) {
            queryWrapper.le((Object)"end_time", (Object)endTimeEnd);
        }
        if (status != null) {
            if (status == 2) {
                queryWrapper.eq((Object)"status", (Object)0);
                queryWrapper.lt((Object)"end_time", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (status == 0) {
                queryWrapper.eq((Object)"status", (Object)status);
                queryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.ge((Object)"end_time", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"))).or()).isNull((Object)"end_time"));
            }
        }
        queryWrapper.eq((Object)"is_recommend", (Object)0);
        if (StringUtils.isNotEmpty((String)sort)) {
            switch (sort) {
                case "endTimeAsc": {
                    queryWrapper.orderByAsc((Object)"IF(isnull(end_time),1,0)");
                    queryWrapper.orderByAsc((Object)"end_time");
                    queryWrapper.orderByAsc((Object)"create_time");
                    break;
                }
                case "endTimeDesc": {
                    queryWrapper.orderByAsc((Object)"IF(isnull(end_time),0,1)");
                    queryWrapper.orderByDesc((Object)"end_time");
                    queryWrapper.orderByDesc((Object)"create_time");
                    break;
                }
                case "createTimeAsc": {
                    queryWrapper.orderByAsc((Object)"create_time");
                    break;
                }
                case "createTimeDesc": {
                    queryWrapper.orderByDesc((Object)"create_time");
                }
            }
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        return this.todoMessageMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public IPage<TodoMessage> groupTodoMessages(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer status, Integer isRecommend, String createTimeStart, String createTimeEnd) {
        if (status != null && status == 1) {
            return this.groupCompleteTodoMessages(userId, enterpriseId, pageNumber, pageSize, categoryList, isExecutor, sort, endTimeStart, endTimeEnd, isRecommend, createTimeStart, createTimeEnd);
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        int start = pageNumber * pageSize;
        int c = this.todoMessageMapper.countGroupTodoMessages(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, status);
        List<TodoMessage> todoMessageList = this.todoMessageMapper.groupTodoMessages(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, status, start, pageSize);
        this.setTag0(todoMessageList, true);
        this.setExtInfo(todoMessageList);
        page.setTotal((long)c);
        page.setRecords(todoMessageList);
        return page;
    }

    private void setExtInfo(List<TodoMessage> todoMessageList) {
        if (Util.isEmpty(todoMessageList)) {
            return;
        }
        List<Long> list = todoMessageList.stream().map(TodoMessage::getId).filter(Objects::nonNull).toList();
        if (Util.isEmpty(list)) {
            return;
        }
        List todoMsgExtList = this.todoMsgExtMapper.selectList((Wrapper)new LambdaQueryWrapper(TodoMsgExt.class).in(TodoMsgExt::getId, list));
        if (Util.isEmpty((Collection)todoMsgExtList)) {
            return;
        }
        Map<Long, TodoMsgExt> extMap = todoMsgExtList.stream().collect(Collectors.toMap(TodoMsgExt::getId, v -> v));
        for (TodoMessage record : todoMessageList) {
            TodoMsgExt todoMsgExt = extMap.get(record.getId());
            if (todoMsgExt == null) continue;
            record.setLinkUrl(todoMsgExt.getLinkUrl());
        }
    }

    private void setTag0(List<TodoMessage> todoMessageList, boolean replaceContent) {
        if (Util.isEmpty(todoMessageList)) {
            return;
        }
        List<Long> list = todoMessageList.stream().map(TodoMessage::getTag).filter(Objects::nonNull).toList();
        if (Util.isEmpty(list)) {
            return;
        }
        List todoMsgTagList = this.todoMsgTagMapper.selectList((Wrapper)new LambdaQueryWrapper(TodoMsgTag.class).in(TodoMsgTag::getId, list));
        Map<Long, TodoMsgTag> tagMap = todoMsgTagList.stream().collect(Collectors.toMap(TodoMsgTag::getId, v -> v));
        for (TodoMessage record : todoMessageList) {
            if (record.getTag() == null) continue;
            if (Util.compare2((Comparable)Integer.valueOf(record.getTagViewCount()), (Comparable)Integer.valueOf(1)) == 0) {
                record.setTagView(false);
                record.setTagFlag(false);
                continue;
            }
            TodoMsgTag todoMsgTag = tagMap.get(record.getTag());
            if (todoMsgTag != null) {
                record.setTagFlag(true);
                record.setTagView(true);
                if (!replaceContent) continue;
                record.setContent(todoMsgTag.getContent());
                continue;
            }
            record.setTagView(false);
            record.setTagFlag(false);
        }
    }

    @Override
    public IPage<TodoMessage> extendTodoMessagesGroup(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer status, Integer isRecommend, String createTimeStart, String createTimeEnd, Long tag) {
        if (status != null && status == 1) {
            Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
            IPage<TodoMessage> iPage = this.todoMessageMapper.extendCompleteTodoMessagesGroup((Page<TodoMessage>)page, userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, tag);
            this.setTag0(iPage.getRecords(), false);
            this.setExtInfo(iPage.getRecords());
            return iPage;
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<TodoMessage> todoMessageIPage = this.todoMessageMapper.extendTodoMessagesGroup((Page<TodoMessage>)page, userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, tag, status);
        return todoMessageIPage;
    }

    @Override
    public int countExtendTodoMessagesGroup(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer status, Integer isRecommend, String createTimeStart, String createTimeEnd, Long tag) {
        if (status != null && status == 1) {
            int l = this.todoMessageMapper.countExtendCompleteTodoMessagesGroup(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, tag);
            return l;
        }
        int l = this.todoMessageMapper.countExtendTodoMessagesGroup(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, tag, status);
        return l;
    }

    @Override
    public List<TodoMessage> getTodoMessagesByTime(Integer userId, Integer enterpriseId, String startTime, String endTime) {
        return this.todoMessageMapper.getTodoMessagesByTime(userId, enterpriseId, startTime, endTime);
    }

    @Override
    public List<TodoMessage> getCompleteTodoMessagesByTime(Integer userId, Integer enterpriseId, String startTime, String endTime) {
        return this.todoMessageMapper.getCompleteTodoMessagesByTime(userId, enterpriseId, startTime, endTime);
    }

    @Override
    public TodoMessage getTodoMessageById(Long id) {
        if (id == null) {
            return null;
        }
        return (TodoMessage)this.todoMessageMapper.selectById(id);
    }

    @Override
    public TodoMessageHistory getCompleteTodoMessageById(Long id) {
        if (id == null) {
            return null;
        }
        return (TodoMessageHistory)this.todoMessageHistoryMapper.selectById(id);
    }

    @Override
    public List<TodoMessage> batchGetTodoMessageById(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        List todoMessageList = this.todoMessageMapper.selectBatchIds(idList);
        return todoMessageList;
    }

    @Override
    public List<TodoMessageHistory> batchGetCompleteTodoMessageById(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        List todoMessageHistoryList = this.todoMessageHistoryMapper.selectBatchIds(idList);
        return todoMessageHistoryList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public TodoMsgService.TodoMsgCompleteResult completeTodoMessage(String objectType, Integer objectId, String objectIds, Integer subId, Integer srcUserId, List<Integer> completeUserIdList, boolean deleteOtherUser, boolean deleteMsgFlag, Consumer<LambdaQueryWrapper<TodoMessage>> consumer) {
        List list;
        LambdaQueryWrapper queryWrapper;
        TodoMsgService.TodoMsgCompleteResult todoMsgCompleteResult = new TodoMsgService.TodoMsgCompleteResult();
        ArrayList allMsgList = new ArrayList();
        if (deleteOtherUser) {
            List deleteList;
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
            if (objectId != null) {
                queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
            }
            if (Util.isNotEmpty((CharSequence)objectIds)) {
                queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
            }
            if (subId != null) {
                queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
            }
            if (srcUserId != null) {
                queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
            }
            queryWrapper.eq(TodoMessage::getIsExecutor, (Object)1);
            if (Util.isNotEmpty(completeUserIdList)) {
                queryWrapper.notIn(TodoMessage::getTargetUserId, completeUserIdList);
            }
            if (consumer != null) {
                consumer.accept((LambdaQueryWrapper<TodoMessage>)queryWrapper);
            }
            if (Util.isNotEmpty((Collection)(deleteList = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
                deleteList.forEach(todoMessage -> todoMessage.setDeleteTime(LocalDateTime.now()));
                this.todoMessageMapper.batchSaveTodoMessagesDelByObject(deleteList);
                this.todoMessageMapper.deleteBatchIds(deleteList.stream().map(TodoMessage::getId).toList());
                allMsgList.addAll(deleteList);
            }
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        if (Util.isNotEmpty((CharSequence)objectIds)) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
        }
        if (Util.isNotEmpty(completeUserIdList)) {
            queryWrapper.in(TodoMessage::getTargetUserId, completeUserIdList);
        }
        if (consumer != null) {
            consumer.accept((LambdaQueryWrapper<TodoMessage>)queryWrapper);
        }
        if (Util.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            for (TodoMessage todoMessage2 : list) {
                todoMessage2.setStatus(1);
                todoMessage2.setCompleteTime(LocalDateTime.now());
            }
            this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(list);
            this.todoMessageMapper.deleteBatchIds(list.stream().map(TodoMessage::getId).toList());
            ArrayList<TodoMessage> waitList = new ArrayList<TodoMessage>();
            Set linkIdList = list.stream().map(TodoMessage::getLinkId).filter(Objects::nonNull).collect(Collectors.toSet());
            for (Long l : linkIdList) {
                List<TodoMessage> todoMessageList = this.waitMove2History(l);
                if (!Util.isNotEmpty(todoMessageList)) continue;
                waitList.addAll(todoMessageList);
            }
            if (Util.isNotEmpty(waitList)) {
                waitList.forEach(todoMessage -> todoMessage.setDeleteTime(LocalDateTime.now()));
                this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(waitList);
                this.todoMessageMapper.deleteBatchIds(waitList.stream().map(TodoMessage::getId).toList());
                list.addAll(waitList);
            }
            allMsgList.addAll(list);
        }
        todoMsgCompleteResult.setUserIdList(allMsgList.stream().map(TodoMessage::getTargetUserId).distinct().toList());
        todoMsgCompleteResult.setTodoMsgIdList(allMsgList.stream().map(TodoMessage::getId).toList());
        todoMsgCompleteResult.setLinkIdList(allMsgList.stream().map(TodoMessage::getLinkId).filter(Objects::nonNull).distinct().toList());
        return todoMsgCompleteResult;
    }

    private List<TodoMessage> waitMove2History(long linkId) {
        List todoMessageList = this.todoMessageMapper.selectList((Wrapper)new LambdaQueryWrapper(TodoMessage.class).eq(TodoMessage::getLinkId, (Object)linkId));
        for (TodoMessage todoMessage : todoMessageList) {
            if (Util.compare2((Comparable)todoMessage.getIsExecutor(), (Comparable)Integer.valueOf(1)) != 0) continue;
            return new ArrayList<TodoMessage>();
        }
        return todoMessageList;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean completeTodoMessage(Long todoMessageId) {
        if (todoMessageId == null) {
            return false;
        }
        TodoMessage todoMessage = this.getTodoMessageById(todoMessageId);
        if (todoMessage == null) {
            return false;
        }
        todoMessage.setStatus(1);
        try {
            List<TodoMessage> todoMessageList;
            todoMessage.setCompleteTime(LocalDateTime.now());
            this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(List.of(todoMessage));
            this.todoMessageMapper.deleteById(todoMessageId);
            ArrayList<TodoMessage> waitList = new ArrayList<TodoMessage>();
            if (todoMessage.getLinkId() != null && Util.isNotEmpty(todoMessageList = this.waitMove2History(todoMessage.getLinkId()))) {
                waitList.addAll(todoMessageList);
            }
            if (Util.isNotEmpty(waitList)) {
                this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(waitList);
                this.todoMessageMapper.deleteBatchIds(waitList.stream().map(TodoMessage::getId).toList());
            }
            return true;
        }
        catch (Exception e) {
            log.error("completeTodoMessage error", (Throwable)e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public boolean batchCompleteTodoMessage(List<Long> todoMessageListId) {
        if (Util.isEmpty(todoMessageListId)) {
            return false;
        }
        try {
            List<TodoMessage> list = this.batchGetTodoMessageById(todoMessageListId);
            for (TodoMessage todoMessage : list) {
                todoMessage.setStatus(1);
                todoMessage.setCompleteTime(LocalDateTime.now());
            }
            this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(list);
            this.todoMessageMapper.deleteBatchIds(list.stream().map(TodoMessage::getId).toList());
            ArrayList<TodoMessage> waitList = new ArrayList<TodoMessage>();
            Set linkIdList = list.stream().map(TodoMessage::getLinkId).filter(Objects::nonNull).collect(Collectors.toSet());
            for (Long l : linkIdList) {
                List<TodoMessage> todoMessageList = this.waitMove2History(l);
                if (!Util.isNotEmpty(todoMessageList)) continue;
                waitList.addAll(todoMessageList);
            }
            if (Util.isNotEmpty(waitList)) {
                this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(waitList);
                this.todoMessageMapper.deleteBatchIds(waitList.stream().map(TodoMessage::getId).toList());
                list.addAll(waitList);
            }
            for (TodoMessage todoMessage : list) {
                this.userEventNotify.notifyUserOnTodoMsg(todoMessage.getTargetUserId(), todoMessage.getEnterpriseId(), todoMessage.getId(), UserEventNotify.Operation.UPDATE);
            }
            return true;
        }
        catch (Exception e) {
            log.error("batchCompleteTodoMessage error", (Throwable)e);
            return false;
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public TodoMsgService.TodoMsgDeleteResult deleteTodoMessageIf4Optimize0(String objectType, Integer objectId, String objectIds, Integer subId, List<Integer> targetUserIdList, Integer srcUserId, boolean deleteMsgFlag, Long createTimeMsIf4Optimize, Consumer<LambdaQueryWrapper<TodoMessage>> consumer, Integer groupId) {
        List list;
        TodoMsgService.TodoMsgDeleteResult todoMsgDeleteResult = new TodoMsgService.TodoMsgDeleteResult();
        ArrayList<Long> linkIdList = new ArrayList<Long>();
        ArrayList<Long> todoMsgIdList = new ArrayList<Long>();
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        if (Util.isNotEmpty((CharSequence)objectIds)) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
        }
        if (Util.isNotEmpty(targetUserIdList)) {
            queryWrapper.in(TodoMessage::getTargetUserId, targetUserIdList);
        }
        if (srcUserId != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
        }
        if (groupId != null) {
            queryWrapper.eq(TodoMessage::getEnterpriseId, (Object)groupId);
        }
        if (createTimeMsIf4Optimize != null) {
            LocalDateTime createTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(createTimeMsIf4Optimize), Util.GMT_08);
            queryWrapper.gt(TodoMessage::getCreateTime, (Object)createTime.plusHours(-1 * Math.max(1, this.msgHubSharedConfig.getTodoMsgCreateTimeHour())));
        }
        if (consumer != null) {
            consumer.accept((LambdaQueryWrapper<TodoMessage>)queryWrapper);
        }
        if (Util.isEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            return todoMsgDeleteResult;
        }
        for (TodoMessage todoMessage : list) {
            todoMessage.setDeleteTime(LocalDateTime.now());
            if (todoMessage.getLinkId() != null) {
                linkIdList.add(todoMessage.getLinkId());
            }
            todoMsgIdList.add(todoMessage.getId());
            userIdList.add(todoMessage.getTargetUserId());
        }
        this.todoMessageMapper.batchSaveTodoMessagesDelByObject(list);
        this.todoMessageMapper.deleteBatchIds(list.stream().map(TodoMessage::getId).toList());
        todoMsgDeleteResult.setLinkIdList(linkIdList.stream().distinct().filter(Objects::nonNull).toList());
        todoMsgDeleteResult.setTodoMsgIdList(todoMsgIdList);
        todoMsgDeleteResult.setUserIdList(userIdList);
        return todoMsgDeleteResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public long moveCompleteTodoMsg2Delete(List<Long> linkTaskIdList) {
        List todoMessageHistoryList = this.todoMessageHistoryMapper.selectList((Wrapper)new LambdaQueryWrapper(TodoMessageHistory.class).in(TodoMessageHistory::getLinkId, linkTaskIdList));
        if (Util.isEmpty((Collection)todoMessageHistoryList)) {
            return 0L;
        }
        for (TodoMessageHistory todoMessageHistory : todoMessageHistoryList) {
            todoMessageHistory.setDeleteTime(LocalDateTime.now());
        }
        this.todoMessageMapper.save2Del(todoMessageHistoryList);
        this.todoMessageHistoryMapper.deleteBatchIds(todoMessageHistoryList.stream().map(TodoMessageHistory::getId).toList());
        return todoMessageHistoryList.size();
    }

    @Override
    public boolean updateTodoMessagesByObject(String objectType, Integer objectId, String objectIds, Integer subId, Integer targetUserId, Integer srcUserId, String content, String endTime) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        if (StringUtils.isNotBlank((String)objectIds)) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
        }
        if (targetUserId != null) {
            queryWrapper.eq(TodoMessage::getTargetUserId, (Object)targetUserId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            for (TodoMessage message : list) {
                if (StringUtils.isNotBlank((String)content)) {
                    message.setContent(content);
                }
                if (StringUtils.isNotBlank((String)endTime)) {
                    message.setEndTime(Util.dateTime((String)endTime, (String[])new String[0]));
                }
                this.todoMessageMapper.updateById(message);
            }
        }
        return true;
    }

    private TodoMessage todoMsg0(TodoMessageTrait.TodoMsgRequestModel todoMsgRequestModel, Integer targetUserId, Integer isExecutor) {
        TodoMessage todoMessage = new TodoMessage();
        todoMessage.setTargetUserId(targetUserId);
        todoMessage.setIsExecutor(isExecutor);
        todoMessage.setEnterpriseId(todoMsgRequestModel.getEnterpriseId());
        todoMessage.setSrcUserId(todoMsgRequestModel.getSrcUserId());
        todoMessage.setCategory(todoMsgRequestModel.getCategory());
        todoMessage.setObjectType(todoMsgRequestModel.getObjectType());
        todoMessage.setObjectId(todoMsgRequestModel.getObjectId());
        todoMessage.setObjectIds(todoMsgRequestModel.getObjectIds());
        todoMessage.setSubId(todoMsgRequestModel.getSubId());
        todoMessage.setDetails(todoMsgRequestModel.getDetails());
        todoMessage.setContent(todoMsgRequestModel.getContent());
        todoMessage.setI18nKey(todoMsgRequestModel.getI18nKey());
        todoMessage.setI18nParam(todoMsgRequestModel.getI18nParam());
        todoMessage.setStatus(0);
        todoMessage.setCanComplete(todoMsgRequestModel.getCanComplete());
        todoMessage.setIsRecommend(todoMsgRequestModel.getIsRecommend());
        todoMessage.setApproveFlag(todoMsgRequestModel.getApproveFlag());
        todoMessage.setTitle(todoMsgRequestModel.getTitle());
        todoMessage.setCreateTime(Optional.ofNullable(todoMsgRequestModel.getCreateTime()).orElse(LocalDateTime.now()));
        todoMessage.setEndTime(todoMsgRequestModel.getEndTime());
        if (Util.isNotEmpty((CharSequence)todoMsgRequestModel.getTagStr())) {
            todoMessage.setTag(TagCodec.decode(todoMsgRequestModel.getTagStr()));
        }
        return todoMessage;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public List<TodoMsgService.OneTodoMessageSaveResult> saveOneTodoMessage(List<OneTodoMessageSaveRequest> oneTodoMessageSaveRequestList, Function<TodoMessage, TodoMsgExt> sourceGet) {
        LinkedHashMap<Long, TodoMsgService.OneTodoMessageSaveResult> oneTodoMessageSaveResultMap = new LinkedHashMap<Long, TodoMsgService.OneTodoMessageSaveResult>();
        ArrayList<TodoMessage> todoMessageList = new ArrayList<TodoMessage>();
        for (OneTodoMessageSaveRequest oneTodoMessageSaveRequest : oneTodoMessageSaveRequestList) {
            TodoMsgService.OneTodoMessageSaveResult oneTodoMessageSaveResult = new TodoMsgService.OneTodoMessageSaveResult();
            HashMap<Integer, Long> todoMsgIdMap = new HashMap<Integer, Long>();
            oneTodoMessageSaveResult.setTodoMsgIdMap(todoMsgIdMap);
            TodoMsgId todoMsgId = new TodoMsgId();
            this.todoMsgIdMapper.insert(todoMsgId);
            Long linkId = todoMsgId.getId();
            oneTodoMessageSaveResult.setLinkId(linkId);
            oneTodoMessageSaveResultMap.put(linkId, oneTodoMessageSaveResult);
            for (TodoMessageSaveRequest messageSaveRequest : oneTodoMessageSaveRequest.getTodoMessageSaveRequestList()) {
                TodoMessage todoMessage2;
                TodoMessageTrait.TodoMsgRequestModel todoMsgRequestModel = messageSaveRequest.getTodoMsgRequestModel();
                for (Integer userId : todoMsgRequestModel.getTargetUserIdList()) {
                    todoMessage2 = this.todoMsg0(todoMsgRequestModel, userId, 1);
                    todoMessage2.setLinkId(linkId);
                    todoMessage2.setDeleteWhenExpired(todoMsgRequestModel.isDeleteWhenExpired());
                    todoMessageList.add(todoMessage2);
                }
                if (!Util.isNotEmpty((Collection)todoMsgRequestModel.getCcUserIdList())) continue;
                for (Integer userId : todoMsgRequestModel.getCcUserIdList()) {
                    todoMessage2 = this.todoMsg0(todoMsgRequestModel, userId, 0);
                    todoMessage2.setLinkId(linkId);
                    todoMessage2.setDeleteWhenExpired(todoMsgRequestModel.isDeleteWhenExpired());
                    todoMessageList.add(todoMessage2);
                }
            }
        }
        for (TodoMessage todoMessage3 : todoMessageList) {
            if (todoMessage3.getTag() != null) continue;
            todoMessage3.setTag(this.todoMsgTagService.nextTag());
        }
        this.todoMessageMapper.saveBatch(todoMessageList);
        todoMessageList.stream().map(todoMessage -> {
            TodoMsgEventTrace todoMsgEventTrace = new TodoMsgEventTrace();
            todoMsgEventTrace.setId(todoMessage.getId());
            return todoMsgEventTrace;
        }).forEach(arg_0 -> ((TodoMsgEventTraceMapper)this.todoMsgEventTraceMapper).insert(arg_0));
        if (sourceGet != null) {
            for (TodoMessage todoMessage3 : todoMessageList) {
                TodoMsgExt todoMsgExt = sourceGet.apply(todoMessage3);
                this.todoMsgExtMapper.insert(todoMsgExt);
            }
        }
        HashMap<String, List> timeGroupIdMap = new HashMap<String, List>();
        for (TodoMessage todoMessage4 : todoMessageList) {
            Long linkId = todoMessage4.getLinkId();
            ((TodoMsgService.OneTodoMessageSaveResult)oneTodoMessageSaveResultMap.get(linkId)).getTodoMsgIdMap().put(todoMessage4.getTargetUserId(), todoMessage4.getId());
            if (todoMessage4.getEndTime() == null || !todoMessage4.isDeleteWhenExpired()) continue;
            String time = Util.formatTime((LocalDateTime)todoMessage4.getEndTime(), (String[])new String[0]);
            timeGroupIdMap.putIfAbsent(time, new ArrayList());
            ((List)timeGroupIdMap.get(time)).add(todoMessage4.getId());
        }
        timeGroupIdMap.forEach((k, longs) -> this.deleteExpiredTodoMsgDelayTaskService.delay(Util.dateTime((String)k, (String[])new String[0]), (List<Long>)longs));
        return new ArrayList<TodoMsgService.OneTodoMessageSaveResult>(oneTodoMessageSaveResultMap.values());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteTodoMessageIfExpired(List<Long> idList) {
        if (Util.isEmpty(idList)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        List todoMessageList = this.todoMessageMapper.selectBatchIds(idList);
        List<TodoMessage> list = todoMessageList.stream().filter(todoMessage -> {
            if (todoMessage.getEndTime() == null) {
                return false;
            }
            if (Util.compare2((Comparable)todoMessage.getEndTime(), (Comparable)now) < 0) {
                todoMessage.setDeleteTime(LocalDateTime.now());
                return true;
            }
            return false;
        }).toList();
        this.todoMessageMapper.batchSaveTodoMessagesDelByObject(list);
        this.todoMessageMapper.deleteBatchIds(list.stream().map(TodoMessage::getId).toList());
    }

    @Override
    public IPage<TodoMessage> getCompleteTodoMessages(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer isRecommend, String createTimeStart, String createTimeEnd) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage<TodoMessage> iPage = this.todoMessageMapper.getCompleteTodoMessages((Page<TodoMessage>)page, userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd);
        return iPage;
    }

    @Override
    public IPage<TodoMessage> groupCompleteTodoMessages(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer isRecommend, String createTimeStart, String createTimeEnd) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        int start = pageNumber * pageSize;
        int c = this.todoMessageMapper.countGroupCompleteTodoMessages(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd);
        List<TodoMessage> todoMessageList = this.todoMessageMapper.groupCompleteTodoMessages(userId, enterpriseId, categoryList, isExecutor, isRecommend, sort, endTimeStart, endTimeEnd, createTimeStart, createTimeEnd, start, pageSize);
        this.setTag0(todoMessageList, true);
        this.setExtInfo(todoMessageList);
        page.setTotal((long)c);
        page.setRecords(todoMessageList);
        return page;
    }

    @Override
    public List<TodoMessage> getEnterpriseTodoMessages(Integer enterpriseId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enterprise_id", (Object)enterpriseId);
        queryWrapper.eq((Object)"status", (Object)0);
        queryWrapper.lt((Object)"end_time", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return this.todoMessageMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<TodoMessage> moveTodoMessage2OtherUser(List<Integer> fromUserIdList, Integer toUserId, List<String> categoryList) {
        Objects.requireNonNull(toUserId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(TodoMessage.class);
        queryWrapper.in(TodoMessage::getTargetUserId, fromUserIdList);
        queryWrapper.in(TodoMessage::getCategory, categoryList);
        queryWrapper.select(new SFunction[]{TodoMessage::getId}).select(new SFunction[]{TodoMessage::getLinkId}).select(new SFunction[]{TodoMessage::getTargetUserId});
        List todoMessageList = this.todoMessageMapper.selectList((Wrapper)queryWrapper);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper(TodoMessage.class);
        updateWrapper.in(TodoMessage::getTargetUserId, fromUserIdList);
        updateWrapper.in(TodoMessage::getCategory, categoryList);
        updateWrapper.set(TodoMessage::getTargetUserId, (Object)toUserId);
        int l = this.todoMessageMapper.update((Wrapper)updateWrapper);
        log.info("moveTodoMessage count: " + l);
        return l > 0 ? todoMessageList : new ArrayList();
    }

    @Override
    public List<TodoMessageGroupVo> categoryViewCount(int userId, int type) {
        String appVer;
        Locale locale;
        Session session = Session.getOrCreate().get();
        List<DefTodoMsgCfService.DefTodoMsgCfNodeView> views = this.defTodoMsgCfService.groupView(userId, type, true);
        ArrayList<TodoMessageGroupVo> vos = new ArrayList<TodoMessageGroupVo>();
        Locale locale2 = locale = session == null ? Locale.CHINA : session.clientInfo().getLocale();
        if (Util.isNotEmpty(views)) {
            for (DefTodoMsgCfService.DefTodoMsgCfNodeView view : views) {
                List<DefTodoMsgCfService.DefTodoMsgCfNodeView> children;
                if (!Util.isNotEmpty(view.getChildren()) || !Util.isNotEmpty(children = view.getChildren())) continue;
                int count = 0;
                int inProgressCount = 0;
                int overdueCount = 0;
                for (DefTodoMsgCfService.DefTodoMsgCfNodeView child : children) {
                    count += child.getCount();
                    inProgressCount += child.getInProgressCount();
                    overdueCount += child.getOverdueCount();
                }
                view.setInProgressCount(inProgressCount);
                view.setOverdueCount(overdueCount);
                DefTodoMsgCfService.DefTodoMsgCfNodeView all = new DefTodoMsgCfService.DefTodoMsgCfNodeView();
                all.setCode(view.getCode() + "_ALL");
                all.setName(this.messageSource.getMessage("todoMsg.ALL", null, locale));
                all.setCount(count);
                all.setInProgressCount(inProgressCount);
                all.setOverdueCount(overdueCount);
                all.setParentCode(view.getCode());
                children.addFirst(all);
                view.setCount(count);
            }
        }
        if (Util.isNotEmpty(views)) {
            for (DefTodoMsgCfService.DefTodoMsgCfNodeView view : views) {
                TodoMessageGroupVo vo = new TodoMessageGroupVo();
                vo.setCode(view.getCode());
                vo.setName(view.nameAtLocale(locale, this.messageSource));
                vo.setCount(view.getCount());
                vo.setInProgressCount(view.getInProgressCount());
                vo.setOverdueCount(view.getOverdueCount());
                vo.setParentCode(view.getParentCode());
                vo.setOrder(view.getOrder());
                if (Util.isNotEmpty(view.getChildren())) {
                    for (DefTodoMsgCfService.DefTodoMsgCfNodeView child : view.getChildren()) {
                        TodoMessageGroupVo childVo = new TodoMessageGroupVo();
                        childVo.setCode(child.getCode());
                        childVo.setName(child.nameAtLocale(locale, this.messageSource));
                        childVo.setCount(child.getCount());
                        childVo.setInProgressCount(child.getInProgressCount());
                        childVo.setOverdueCount(child.getOverdueCount());
                        childVo.setParentCode(child.getParentCode());
                        vo.getChildren().add(childVo);
                    }
                }
                vos.add(vo);
            }
        }
        String string = appVer = session == null ? null : session.clientInfo().getVersion();
        if (session != null && ("Android".equalsIgnoreCase(session.clientInfo().getClient()) || "iOS".equalsIgnoreCase(session.clientInfo().getClient())) && Util.compare2((Comparable)((Object)appVer), (Comparable)((Object)this.msgHubSharedConfig.getAppVer())) < 0) {
            for (TodoMessageGroupVo vo : vos) {
                if (!"TRAINING".equals(vo.getCode()) && !"ALL".equals(vo.getCode())) continue;
                List<TodoMessageGroupVo> children = vo.getChildren();
                Iterator<TodoMessageGroupVo> iterator = children.iterator();
                int c = 0;
                TodoMessageGroupVo training = null;
                while (iterator.hasNext()) {
                    TodoMessageGroupVo next = iterator.next();
                    String objectType = next.getCode();
                    if ("TYPE_TRAINING_COURSE".equals(objectType) || "TYPE_TRAINING_PAPER".equals(objectType) || "TYPE_TRAINING_LEARN".equals(objectType) || "TYPE_TRAINING_OFFLINE".equals(objectType) || "TYPE_TRAINING_OPERATE".equals(objectType)) {
                        c += next.getCount();
                        iterator.remove();
                    }
                    if (!"TYPE_TRAINING".equals(objectType)) continue;
                    training = next;
                }
                if (training == null) continue;
                training.setCount(training.getCount() + c);
            }
        } else {
            for (TodoMessageGroupVo vo : vos) {
                if (!"TRAINING".equals(vo.getCode()) && !"ALL".equals(vo.getCode())) continue;
                List<TodoMessageGroupVo> children = vo.getChildren();
                Iterator<TodoMessageGroupVo> iterator = children.iterator();
                while (iterator.hasNext()) {
                    TodoMessageGroupVo next = iterator.next();
                    String objectType = next.getCode();
                    if (!"TYPE_TRAINING".equals(objectType)) continue;
                    iterator.remove();
                }
            }
        }
        return vos;
    }
}

