/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.dd;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.DDMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.dd.DDSender;
import com.ovopark.messagehub.plugins.dd.DDSubscriber;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.module.shared.BaseResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionOnSubs(value="DD")
@RestController
@RequestMapping(value={"/test/dingding"})
public class TestDDController {
    private static final Logger log = LoggerFactory.getLogger(TestDDController.class);
    @Autowired
    private DDSender ddSender;
    @Autowired
    private KafkaReply kafkaReply;

    @RequestMapping(value={"/send"})
    public BaseResult<Boolean> send(@RequestBody String value) {
        DDMsg mailMsg = (DDMsg)JSONAccessor.impl().read(value, DDMsg.class);
        log.info(mailMsg.getMsgId() + " from HTTP: " + value);
        String msgTraceId = mailMsg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)mailMsg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.DD, meta);
            }).subscribe((Subscriber)new DDSubscriber(this.kafkaReply, this.ddSender));
            return BaseResult.success((Object)true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return BaseResult.error((Object)false, (String)e.getMessage());
        }
    }
}

