/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.dd;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.DDMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.dd.DDMessage;
import com.ovopark.messagehub.plugins.dd.DDSender;
import com.ovopark.messagehub.plugins.dd.DDSubscriber;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.MsgHubPluginsSharedConfig;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="DD")
@Component
public class DDInStream {
    private static final Logger log = LoggerFactory.getLogger(DDInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private DDSender sender;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;
    @Autowired
    MsgHubPluginsSharedConfig msgHubPluginsSharedConfig;
    private final AtomicLong c = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.dd.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-dd", groupId="${messagehub.plugins.dd.kafka.group:messagehub-group-dd}", containerFactory="ddKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        DDMsg msg = (DDMsg)JSONAccessor.impl().read((String)value, DDMsg.class);
        log.info(msg.getMsgTraceId() + " dd from KAFKA: " + String.valueOf(value));
        DDMessage ddMessage = (DDMessage)msg.getBody();
        Integer enterpriseId = ddMessage.getEnterpriseId();
        Set limitDdRateGroupIdList = this.msgHubPluginsSharedConfig.getLimitDdRateGroupIdList();
        if (Util.isNotEmpty((Collection)limitDdRateGroupIdList) && limitDdRateGroupIdList.contains(enterpriseId)) {
            rateLimiter = this.subsRateLimiterClient.get(Subs.DD, enterpriseId.intValue());
            rateLimiter.acquire();
            log.info("dd message rate: " + this.c.incrementAndGet());
            if (this.msgHubPluginsSharedConfig.isTestLimit()) {
                return;
            }
        } else {
            rateLimiter = this.subsRateLimiterClient.get(Subs.DD);
            rateLimiter.acquire();
        }
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)msg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.DD, meta);
            }).subscribe((Subscriber)new DDSubscriber(this.kafkaReply, this.sender));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

