/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.fs;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.FSMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.fs.FSMessage;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.fs.FSSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class FSSubscriber
extends CoreSubscriber<MsgContext<FSMsg>> {
    private static final Logger log = LoggerFactory.getLogger(FSSubscriber.class);
    private final KafkaReply kafkaReply;
    private final FSSender sender;

    public FSSubscriber(KafkaReply kafkaReply, FSSender sender) {
        this.kafkaReply = kafkaReply;
        this.sender = sender;
    }

    public void onNext(MsgContext<FSMsg> msgMsgContext) {
        FSMsg msg = (FSMsg)msgMsgContext.msg();
        FSMessage qwMessage = (FSMessage)msg.getBody();
        FSMessage targetMessage = new FSMessage();
        BeanUtils.copyProperties((Object)qwMessage, (Object)targetMessage);
        List<MessageReply<QWResponse>> replyList = this.sender.send(msg.getUsers(), targetMessage, msgMsgContext);
        for (MessageReply<QWResponse> reply : replyList) {
            this.kafkaReply.reply("messagehub-plugins-reply", reply, msgMsgContext);
        }
    }
}

