/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.fs;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.FSMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.fs.FSMessage;
import com.ovopark.messagehub.plugins.fs.FSSender;
import com.ovopark.messagehub.plugins.fs.FSSubscriber;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.MsgHubPluginsSharedConfig;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="FS")
@Component
public class FSInStream {
    private static final Logger log = LoggerFactory.getLogger(FSInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private FSSender sender;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;
    @Autowired
    MsgHubPluginsSharedConfig msgHubPluginsSharedConfig;
    private final AtomicLong c = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.fs.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-fs", groupId="${messagehub.plugins.fs.kafka.group:messagehub-group-fs}", containerFactory="fsKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        FSMsg msg = (FSMsg)JSONAccessor.impl().read((String)value, FSMsg.class);
        log.info(msg.getMsgTraceId() + " fs from KAFKA: " + String.valueOf(value));
        FSMessage fsMessage = (FSMessage)msg.getBody();
        Integer enterpriseId = fsMessage.getEnterpriseId();
        Set limitFsRateGroupIdList = this.msgHubPluginsSharedConfig.getLimitFsRateGroupIdList();
        if (Util.isNotEmpty((Collection)limitFsRateGroupIdList) && limitFsRateGroupIdList.contains(enterpriseId)) {
            rateLimiter = this.subsRateLimiterClient.get(Subs.FS, enterpriseId.intValue());
            rateLimiter.acquire();
            log.info("fs message rate: " + this.c.incrementAndGet());
            if (this.msgHubPluginsSharedConfig.isTestLimit()) {
                return;
            }
        } else {
            rateLimiter = this.subsRateLimiterClient.get(Subs.FS);
            rateLimiter.acquire();
        }
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)msg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.FS, meta);
            }).subscribe((Subscriber)new FSSubscriber(this.kafkaReply, this.sender));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

