/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.gzh;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.mapper.PluginsCfgMapper;
import com.ovopark.messagehub.plugins.kernel.module.PluginsCfg;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.stereotype.Service;

@ConditionOnSubs(value="GZH")
@Service
public class GZHUserSyncHandler {
    @Resource
    private PluginsCfgMapper pluginsCfgMapper;

    public void syncUser(String userId, String openId, Boolean isSubscribe) {
        String key = "gzh_user:" + userId;
        PluginsCfg pluginsCfg = (PluginsCfg)this.pluginsCfgMapper.selectOne((Wrapper)new LambdaQueryWrapper(PluginsCfg.class).eq(PluginsCfg::getCfgKey, (Object)key));
        if (pluginsCfg == null) {
            pluginsCfg = new PluginsCfg();
            pluginsCfg.setCfgKey(key);
            pluginsCfg.setCfgValue(openId);
            pluginsCfg.setCfgDesc(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.NORM_DATETIME_FORMATTER));
            pluginsCfg.setDelFlag(isSubscribe != false ? 0 : 1);
            this.pluginsCfgMapper.insert((Object)pluginsCfg);
        } else {
            pluginsCfg.setCfgValue(openId);
            pluginsCfg.setCfgDesc(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (DateTimeFormatter)DatePattern.NORM_DATETIME_FORMATTER));
            pluginsCfg.setDelFlag(isSubscribe != false ? 0 : 1);
            this.pluginsCfgMapper.updateById((Object)pluginsCfg);
        }
    }
}

