/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.gzh;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.GZHMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.gzh.GZHSubscriber;
import com.ovopark.messagehub.plugins.gzh.api.WechatServerApi;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.module.shared.BaseResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test/gzh"})
public class TestGZHController {
    private static final Logger log = LoggerFactory.getLogger(TestGZHController.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private PluginsCfgService pluginsCfgService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private WechatServerApi wechatServerApi;

    @RequestMapping(value={"/send"})
    public BaseResult<Boolean> send(@RequestBody String value) {
        GZHMsg msg = (GZHMsg)JSONAccessor.impl().read(value, GZHMsg.class);
        log.info(msg.getMsgTraceId() + " from HTTP: {}", (Object)value);
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)msg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.GZH, meta);
            }).subscribe((Subscriber)new GZHSubscriber(this.kafkaReply, this.pluginsCfgService, this.stringRedisTemplate, this.wechatServerApi));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return BaseResult.success((Object)true);
    }
}

