/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.gzh;

import cn.hutool.http.HttpUtil;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.GZHMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.gzh.GZHMessage;
import com.ovopark.messagehub.plugins.bridge.gzh.GZHResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.gzh.api.WechatServerApi;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class GZHSubscriber
extends CoreSubscriber<MsgContext<GZHMsg>> {
    private static final Logger log = LoggerFactory.getLogger(GZHSubscriber.class);
    private static final String SEND_MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";
    private final KafkaReply kafkaReply;
    private final PluginsCfgService pluginsCfgService;
    private final StringRedisTemplate stringRedisTemplate;
    private final WechatServerApi wechatServerApi;

    public GZHSubscriber(KafkaReply kafkaReply, PluginsCfgService pluginsCfgService, StringRedisTemplate stringRedisTemplate, WechatServerApi wechatServerApi) {
        this.kafkaReply = kafkaReply;
        this.pluginsCfgService = pluginsCfgService;
        this.stringRedisTemplate = stringRedisTemplate;
        this.wechatServerApi = wechatServerApi;
    }

    public void onNext(MsgContext<GZHMsg> msgMsgContext) {
        GZHMsg msg = (GZHMsg)msgMsgContext.msg();
        GZHMessage gzhMessage = (GZHMessage)msg.getBody();
        String gzhTemplateId = gzhMessage.getGzhTemplateId();
        ParamContext paramContext = gzhMessage.getParamContext();
        WxMsgMo wxMsgMo = new WxMsgMo(this);
        wxMsgMo.setTemplate_id(gzhTemplateId);
        wxMsgMo.setData(paramContext);
        wxMsgMo.setUrl(gzhMessage.getUrl());
        List toUserIdList = gzhMessage.getToUserIdList();
        ArrayList<MessageReply> messageReplyList = new ArrayList<MessageReply>();
        String token = this.getToken();
        if (Util.isEmpty((CharSequence)token)) {
            for (Object userId : toUserIdList) {
                String userMsgId = msg.msgIdByUser(((Integer)userId).intValue());
                MessageReply fail = MessageReply.fail((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                fail.setDesc("\u83b7\u53d6token\u5f02\u5e38");
                messageReplyList.add(fail);
            }
        } else {
            String url = SEND_MESSAGE_URL + token;
            for (Integer userId : toUserIdList) {
                MessageReply fail;
                String userMsgId = msg.msgIdByUser(userId.intValue());
                String openId = this.pluginsCfgService.cfg("gzh_user:" + userId);
                if (Util.isEmpty((CharSequence)openId)) {
                    MessageReply fail2 = MessageReply.fail((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                    fail2.setDesc("\u7528\u6237\u672a\u7ed1\u5b9a\u516c\u4f17\u53f7");
                    messageReplyList.add(fail2);
                    continue;
                }
                wxMsgMo.setTouser(openId);
                String userMessage = JSONAccessor.impl().format((Object)wxMsgMo);
                try {
                    String result = HttpUtil.post((String)url, (String)userMessage);
                    log.info("\u53d1\u9001\u6d88\u606f message = {} , result = {}", (Object)userMessage, (Object)result);
                    if (Util.isEmpty((CharSequence)result)) {
                        fail = MessageReply.fail((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                        fail.setDesc("\u8fd4\u56de\u4e3a\u7a7a");
                        messageReplyList.add(fail);
                        continue;
                    }
                    GZHResponse response = (GZHResponse)JSONAccessor.impl().read(result, GZHResponse.class);
                    if (response != null && response.getErrcode() == 0 && "ok".equals(response.getErrmsg())) {
                        MessageReply success = MessageReply.success((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                        success.setDesc("ok");
                        messageReplyList.add(success);
                        continue;
                    }
                    MessageReply fail3 = MessageReply.fail((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                    fail3.setDesc(result);
                    messageReplyList.add(fail3);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25 message = {} , exception = {}", (Object)userMessage, (Object)e);
                    fail = MessageReply.fail((Subs)Subs.GZH, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{userMsgId});
                    fail.setDesc(e.getMessage());
                    messageReplyList.add(fail);
                }
            }
        }
        for (MessageReply messageReply : messageReplyList) {
            this.kafkaReply.reply("messagehub-plugins-reply", messageReply, msgMsgContext);
        }
    }

    private String getToken() {
        String token = (String)this.stringRedisTemplate.opsForValue().get((Object)"wx:token");
        if (Util.isNotEmpty((CharSequence)token)) {
            return token;
        }
        try {
            BaseResult<String> baseResult = this.wechatServerApi.getToken();
            log.info("\u83b7\u53d6token\u7ed3\u679c\uff1a{}", baseResult);
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                token = (String)baseResult.getData();
                return token;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6token\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return null;
    }

    public class WxMsgMo {
        private String touser = "{{WDZ_OPENID}}";
        private String template_id;
        private String url;
        private MiniprogramBean miniprogram;
        private String client_msg_id;
        private Object data;

        public WxMsgMo(GZHSubscriber this$0) {
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public String getTouser() {
            return this.touser;
        }

        public void setTouser(String touser) {
            this.touser = touser;
        }

        public String getTemplate_id() {
            return this.template_id;
        }

        public void setTemplate_id(String template_id) {
            this.template_id = template_id;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public MiniprogramBean getMiniprogram() {
            return this.miniprogram;
        }

        public void setMiniprogram(MiniprogramBean miniprogram) {
            this.miniprogram = miniprogram;
        }

        public String getClient_msg_id() {
            return this.client_msg_id;
        }

        public void setClient_msg_id(String client_msg_id) {
            this.client_msg_id = client_msg_id;
        }

        public class MiniprogramBean {
            private String appid;
            private String pagepath;

            public MiniprogramBean(WxMsgMo this$1) {
            }

            public String getAppid() {
                return this.appid;
            }

            public void setAppid(String appid) {
                this.appid = appid;
            }

            public String getPagepath() {
                return this.pagepath;
            }

            public void setPagepath(String pagepath) {
                this.pagepath = pagepath;
            }
        }
    }

    private class GZHRequest {
        private String requestId;
        private String message;
        private List<Integer> userIds;

        public GZHRequest(GZHSubscriber gZHSubscriber) {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public List<Integer> getUserIds() {
            return this.userIds;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setUserIds(List<Integer> userIds) {
            this.userIds = userIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GZHRequest)) {
                return false;
            }
            GZHRequest other = (GZHRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            List<Integer> this$userIds = this.getUserIds();
            List<Integer> other$userIds = other.getUserIds();
            return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GZHRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            List<Integer> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            return result;
        }

        public String toString() {
            return "GZHSubscriber.GZHRequest(requestId=" + this.getRequestId() + ", message=" + this.getMessage() + ", userIds=" + String.valueOf(this.getUserIds()) + ")";
        }
    }
}

