/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.jg.JiguangPushUtil;
import com.ovopark.messagehub.sdk.model.direct.jg.JPush;
import com.ovopark.messagehub.sdk.model.direct.jg.JPushAccount;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jg"})
public class JGController {
    private static final Logger log = LoggerFactory.getLogger(JGController.class);

    @PostMapping(value={"/registerDeviceAlias"})
    public BaseResult<Boolean> registerDeviceAlias(@RequestParam(value="registrationId") String registrationId, @RequestParam(value="alias") String alias, @RequestParam(value="appKey") String appKey) {
        try {
            String masterSecret = JPushAccount.getMasterSecret((String)appKey);
            if (Util.isNotEmpty((CharSequence)masterSecret)) {
                JiguangPushUtil.registerDeviceAlias(registrationId, alias, appKey, masterSecret);
            }
        }
        catch (Exception e) {
            log.error("registerDeviceAlias", (Throwable)e);
        }
        return BaseResult.success((Object)true);
    }

    @PostMapping(value={"/tdr/push"})
    public BaseResult<Boolean> push(@RequestBody PushNotificationParameter param) {
        log.info("tdr push: " + JSONAccessor.impl().format((Object)param));
        try {
            if (param == null || param.getJpush() == null) {
                return BaseResult.paramError();
            }
            JPush push = param.getJpush();
            param.setAppKey(push.getAppKey());
            param.setSecret(JPushAccount.getMasterSecret((String)push.getAppKey()));
            ArrayList<String> alias = new ArrayList<String>();
            alias.add(push.getPushAlias());
            param.setPushAlias(alias);
            JiguangPushUtil.sendPush(param, true);
        }
        catch (Exception e) {
            log.error("push", (Throwable)e);
        }
        return BaseResult.success((Object)true);
    }
}

