/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.mail;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.bridge.MailMsg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.mail.MailMessage;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.plugins.mail.MailConfig;
import com.ovopark.messagehub.plugins.mail.MailSender;
import com.ovopark.messagehub.plugins.mail.SMTPConfig;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.Subs;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="MAIL")
@Component
public class SimpleSMTPMailSender
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(SimpleSMTPMailSender.class);
    @Autowired
    private PluginsCfgService pluginsCfgService;
    @Autowired
    private MailConfig mailConfig;
    @Autowired
    private SMTPConfig smtpConfig;

    @Override
    public List<MessageReply<?>> send(MailMessage mailMessage, MsgContext<MailMsg> msgMsgContext) {
        MailMsg msg = (MailMsg)msgMsgContext.msg();
        List toMailAddressList = mailMessage.getToMailAddressList();
        MessageReply success = MessageReply.success((Subs)Subs.MAIL, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[0]);
        MessageReply fail = MessageReply.fail((Subs)Subs.MAIL, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[0]);
        String smtpPWD = this.smtpConfig.getPassword();
        if (Util.isEmpty((CharSequence)smtpPWD)) {
            log.warn("smtp pwd is empty: " + this.smtpConfig.getUser());
            fail.setMsgIdList(toMailAddressList.stream().map(arg_0 -> ((MailMsg)msg).msgIdByMail(arg_0)).toList());
            fail.setDesc("smtp pwd error");
            return List.of(fail);
        }
        long start = System.currentTimeMillis();
        msgMsgContext.logger().info(log, " send mail: " + String.valueOf(toMailAddressList) + ", title : " + mailMessage.getTitle());
        try {
            List attachFileList;
            final Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", this.smtpConfig.getHost());
            if (!this.mailConfig.isSsl()) {
                props.put("mail.smtp.port", this.smtpConfig.getPort() > 0 ? String.valueOf(this.smtpConfig.getPort()) : "80");
            } else {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.port", this.smtpConfig.getPort() > 0 ? String.valueOf(this.smtpConfig.getPort()) : "465");
                props.put("mail.smtp.port", this.smtpConfig.getPort() > 0 ? String.valueOf(this.smtpConfig.getPort()) : "465");
                props.put("mail.smtp.ssl.protocols", "TLSv1.2");
            }
            props.put("mail.user", this.smtpConfig.getUser());
            props.put("mail.password", smtpPWD);
            System.setProperty("mail.mime.splitlongparameters", "false");
            Authenticator authenticator = new Authenticator(this){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            };
            Session mailSession = Session.getInstance((Properties)props, (Authenticator)authenticator);
            final String messageIDValue = SimpleSMTPMailSender.genMessageID(props.getProperty("mail.user"));
            MimeMessage message = new MimeMessage(this, mailSession){

                protected void updateMessageID() throws MessagingException {
                    this.setHeader("Message-ID", messageIDValue);
                }
            };
            InternetAddress from = new InternetAddress(this.smtpConfig.getUser(), this.smtpConfig.getUser());
            message.setFrom((Address)from);
            ArrayList<InternetAddress> toList = new ArrayList<InternetAddress>();
            for (Object t : toMailAddressList) {
                InternetAddress toAddress = new InternetAddress((String)t);
                try {
                    toAddress.validate();
                }
                catch (AddressException e) {
                    log.info("error mail address (to): " + (String)t);
                    fail.append(msg.msgIdByMail((String)t));
                    continue;
                }
                toList.add(toAddress);
                success.append(msg.msgIdByMail((String)t));
            }
            if (Util.isNotEmpty(toList)) {
                message.setRecipients(Message.RecipientType.TO, (Address[])toList.toArray(new InternetAddress[0]));
            }
            message.setSentDate(new Date());
            if (Util.isNotEmpty((Collection)mailMessage.getCcMailAddressList())) {
                ArrayList<InternetAddress> ccList = new ArrayList<InternetAddress>();
                for (Object c : mailMessage.getCcMailAddressList()) {
                    InternetAddress ccAddress = new InternetAddress((String)c);
                    try {
                        ccAddress.validate();
                    }
                    catch (AddressException e) {
                        log.info("error mail address (cc): " + (String)c);
                        continue;
                    }
                    ccList.add(ccAddress);
                }
                message.setRecipients(Message.RecipientType.CC, (Address[])ccList.toArray(new InternetAddress[0]));
            }
            message.setSubject(mailMessage.getTitle());
            MimeMultipart multipart = new MimeMultipart();
            msgMsgContext.logger().info(log, "to add attachment");
            List attachUrls = mailMessage.getAttachUrls();
            if (Util.isNotEmpty((Collection)attachUrls)) {
                for (Object attachUrl : attachUrls) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    URL url = new URL(((String)attachUrl).replace("%3A", ":").replace("%2F", "/"));
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
                    mimeBodyPart.setFileName(MimeUtility.encodeText((String)url.getPath().substring(url.getPath().lastIndexOf("/") + 1), (String)"gb2312", (String)"B"));
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            if (Util.isNotEmpty((Collection)(attachFileList = mailMessage.getAttachFileList()))) {
                for (MessageRequest.AttachFile attachFile : attachFileList) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    URL url = new URL(attachFile.getUrl().replace("%3A", ":").replace("%2F", "/"));
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)new URLDataSource(url)));
                    mimeBodyPart.setFileName(MimeUtility.encodeText((String)attachFile.getName(), (String)"gb2312", (String)"B"));
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            String contentType = Util.compare2((Comparable)((Object)mailMessage.getType()), (Comparable)((Object)MessageRequest.MailAttach.ContentType.text.name())) == 0 ? "text/plain;charset=UTF-8" : "text/html;charset=UTF-8";
            mimeBodyPart.setContent((Object)mailMessage.getContent(), contentType);
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            message.setContent((Multipart)multipart);
            msgMsgContext.logger().info(log, "ok , all data is ready ,we send mail");
            try {
                Transport.send((Message)message);
            }
            catch (MessagingException e) {
                msgMsgContext.logger().info(log, "error , transport error");
                msgMsgContext.logger().error(log, (Throwable)e, e.getMessage());
                throw e;
            }
            msgMsgContext.logger().info(log, "ok , send mail successfully, cost: " + Util.costTime((long)start));
            return List.of(success, fail);
        }
        catch (Exception e) {
            msgMsgContext.logger().error(log, (Throwable)e, e.getMessage());
            fail.setMsgIdList(toMailAddressList.stream().map(arg_0 -> ((MailMsg)msg).msgIdByMail(arg_0)).toList());
            fail.setDesc("fail: " + e.getMessage());
            return List.of(fail);
        }
    }

    static String genMessageID(String mailFrom) {
        String[] mailInfo = mailFrom.split("@");
        String domain = mailFrom;
        int index = mailInfo.length - 1;
        if (index >= 0) {
            domain = mailInfo[index];
        }
        UUID uuid = UUID.randomUUID();
        StringBuffer messageId = new StringBuffer();
        messageId.append('<').append(uuid.toString()).append('@').append(domain).append('>');
        return messageId.toString();
    }
}

