/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.mail;

import com.ovopark.messagehub.plugins.bridge.MailMsg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.mail.MailMessage;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.mail.AliMailSender;
import com.ovopark.messagehub.plugins.mail.MailConfig;
import com.ovopark.messagehub.plugins.mail.MailSender;
import com.ovopark.messagehub.plugins.mail.SimpleSMTPMailSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@ConditionOnSubs(value="MAIL")
@Component
public class MailSenderProxy
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(MailSenderProxy.class);
    @Autowired
    private SimpleSMTPMailSender simpleSMTPMailSender;
    @Autowired
    private AliMailSender aliMailSender;
    @Autowired
    private MailConfig mailConfig;

    @Override
    public List<MessageReply<?>> send(MailMessage mailMessage, MsgContext<MailMsg> msgMsgContext) {
        if ("aliyun".equals(this.mailConfig.getMailImpl())) {
            return this.aliMailSender.send(mailMessage, msgMsgContext);
        }
        if ("smtp".equals(this.mailConfig.getMailImpl())) {
            return this.simpleSMTPMailSender.send(mailMessage, msgMsgContext);
        }
        throw new UnsupportedOperationException("impl: " + this.mailConfig.getMailImpl());
    }
}

