/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.mock;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.mock.MockSubscriber;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class MockInStream {
    private static final Logger log = LoggerFactory.getLogger(MockInStream.class);
    @Autowired
    private KafkaReply kafkaReply;

    @KafkaListener(concurrency="${messagehub.plugins.mail.consumerConcurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-mock", containerFactory="mainKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        Msg msg = (Msg)JSONAccessor.impl().read((String)value, Msg.class);
        log.info(msg.getMsgTraceId() + " from KAFKA: " + String.valueOf(value));
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, msg)).subscribe((Subscriber)new MockSubscriber(this.kafkaReply));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

