/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.sms.aliyun;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.SMSMsg;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.plugins.sms.aliyun.AliSMSConfig;
import com.ovopark.messagehub.plugins.sms.aliyun.AliSMSSubscriber;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.module.shared.redis.RateLimiter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="SMS")
@Component
public class AliSMSInStream {
    private static final Logger log = LoggerFactory.getLogger(AliSMSInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;
    @Autowired
    private PluginsCfgService pluginsCfgService;
    @Autowired
    private AliSMSConfig aliSmsConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.sms.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-sms", groupId="${messagehub.plugins.sms.kafka.group:messagehub-group-sms-aliyun}", containerFactory="smsKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        String smsImpl = null;
        Iterable headers = record.headers().headers("sms-impl");
        for (Header header : headers) {
            if (!"sms-impl".equals(header.key())) continue;
            smsImpl = new String(header.value(), StandardCharsets.UTF_8);
            break;
        }
        log.info("smsImpl: " + smsImpl);
        if (!"aliyun".equalsIgnoreCase(smsImpl)) {
            return;
        }
        Object value = record.value();
        SMSMsg smsMsg = (SMSMsg)JSONAccessor.impl().read((String)value, SMSMsg.class);
        log.info(smsMsg.getMsgTraceId() + " from KAFKA: " + String.valueOf(value));
        RateLimiter rateLimiter = this.subsRateLimiterClient.get(Subs.SMS);
        rateLimiter.acquire();
        String msgTraceId = smsMsg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)smsMsg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.SMS, meta);
            }).subscribe((Subscriber)new AliSMSSubscriber(this.kafkaReply, this.pluginsCfgService, this.aliSmsConfig));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

