/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.sms.aliyun;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.SMSMsg;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.bridge.sms.SMSMessage;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.plugins.sms.aliyun.AliSMSConfig;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.sms.SMSResult;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliSMSSubscriber
extends CoreSubscriber<MsgContext<SMSMsg>> {
    private static final Logger log = LoggerFactory.getLogger(AliSMSSubscriber.class);
    private final KafkaReply kafkaReply;
    private final PluginsCfgService pluginsCfgService;
    private final AliSMSConfig aliSmsConfig;

    public AliSMSSubscriber(KafkaReply kafkaReply, PluginsCfgService pluginsCfgService, AliSMSConfig aliSmsConfig) {
        this.kafkaReply = kafkaReply;
        this.pluginsCfgService = pluginsCfgService;
        this.aliSmsConfig = aliSmsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(MsgContext<SMSMsg> msgMsgContext) {
        SMSMsg msg = (SMSMsg)msgMsgContext.msg();
        SMSMessage payload = (SMSMessage)msg.getBody();
        String keyId = this.pluginsCfgService.cfg("sms.ALIBABA_CLOUD_ACCESS_KEY_ID");
        String keySecret = this.pluginsCfgService.cfg("sms.ALIBABA_CLOUD_ACCESS_KEY_SECRET");
        String signName = msg.isTdr() ? this.pluginsCfgService.cfg("sms.TDR.ALIBABA_CLOUD_SIGN_NAME") : (msg.isInst() ? this.pluginsCfgService.cfg("sms.INST.ALIBABA_CLOUD_SIGN_NAME") : this.pluginsCfgService.cfg("sms.ALIBABA_CLOUD_SIGN_NAME"));
        SMSResult smsResult = new SMSResult();
        smsResult.setPhone(payload.getPhone());
        try {
            boolean f;
            msgMsgContext.getAttr("SMS_RESULT");
            Client client = this.createClient(keyId, keySecret);
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setPhoneNumbers(payload.getPhone()).setSignName(signName).setTemplateCode(payload.getMId()).setTemplateParam(JSONAccessor.impl().format((Object)payload.getKvArgs()));
            SendSmsResponse sendSmsResponse = client.sendSms(sendSmsRequest);
            log.info("sms result: " + JSONAccessor.impl().format((Object)sendSmsResponse));
            Integer statusCode = sendSmsResponse.getStatusCode();
            SendSmsResponseBody sendSmsResponseBody = sendSmsResponse.getBody();
            boolean bl = f = Util.compare2((Comparable)statusCode, (Comparable)Integer.valueOf(200)) == 0 && sendSmsResponseBody != null && "OK".equals(sendSmsResponseBody.getCode());
            if (f) {
                smsResult.setSuccess(true);
                smsResult.setCode(sendSmsResponseBody.getCode());
                smsResult.setDesc(sendSmsResponseBody.getMessage());
                MessageReply success = MessageReply.success((Subs)Subs.SMS, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{msg.msgIdByPhone(payload.getPhone())});
                success.setDesc(JSONAccessor.impl().format((Object)sendSmsResponseBody));
                this.kafkaReply.reply("messagehub-plugins-reply", success, msgMsgContext);
            } else {
                smsResult.setSuccess(false);
                smsResult.setDesc(sendSmsResponseBody == null ? "error" : sendSmsResponseBody.getMessage());
                smsResult.setCode(sendSmsResponseBody == null ? "error" : sendSmsResponseBody.getCode());
                MessageReply fail = MessageReply.fail((Subs)Subs.SMS, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{msg.msgIdByPhone(payload.getPhone())});
                fail.setDesc(JSONAccessor.impl().format((Object)sendSmsResponseBody));
                this.kafkaReply.reply("messagehub-plugins-reply", fail, msgMsgContext);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            smsResult.setSuccess(false);
            smsResult.setDesc("error: " + e.getMessage());
            MessageReply fail = MessageReply.fail((Subs)Subs.SMS, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{msg.msgIdByPhone(payload.getPhone())});
            fail.setDesc("error: " + e.getMessage());
            this.kafkaReply.reply("messagehub-plugins-reply", fail, msgMsgContext);
        }
        finally {
            msgMsgContext.setAttr("SMS_RESULT", (Object)smsResult);
        }
    }

    private Client createClient(String keyId, String keySecret) throws Exception {
        return (Client)Util.globalTtl().putIfAbsentAndGet((Comparable)((Object)("SMS_CLIENT_ALIYUN:" + keyId + ":" + keySecret)), () -> {
            Config config = new Config().setAccessKeyId(keyId).setAccessKeySecret(keySecret);
            config.endpoint = "dysmsapi.aliyuncs.com";
            try {
                return new Client(config);
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException((Throwable)e);
            }
        }, 60L, TimeUnit.SECONDS);
    }
}

