/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.sms.aliyun;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.SMSMsg;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.plugins.sms.aliyun.AliSMSConfig;
import com.ovopark.messagehub.plugins.sms.aliyun.AliSMSSubscriber;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.messagehub.sdk.model.internal.sms.SMSResult;
import com.ovopark.module.shared.BaseResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ConditionOnSubs(value="SMS")
@RestController
@RequestMapping(value={"/sms/aliyun"})
public class AliSMSController {
    private static final Logger log = LoggerFactory.getLogger(AliSMSController.class);
    @Autowired
    private PluginsCfgService pluginsCfgService;
    @Autowired
    private AliSMSConfig aliSmsConfig;
    @Autowired
    private KafkaReply kafkaReply;

    @RequestMapping(value={"/send"})
    public BaseResult<SMSResult> send(@RequestBody String value) {
        return this.send0(value);
    }

    private BaseResult<SMSResult> send0(String value) {
        SMSMsg smsMsg = (SMSMsg)JSONAccessor.impl().read(value, SMSMsg.class);
        log.info(smsMsg.getMsgId() + " from HTTP: " + value);
        String msgTraceId = smsMsg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        try {
            MsgContext msgContext = new MsgContext(msgTraceId, (Msg)smsMsg);
            Stream.from((Object)msgContext).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                meta.put("provider", "aliyun");
                PluginsManager.getOrCreate().heartbeat(Subs.SMS, meta);
            }).subscribe((Subscriber)new AliSMSSubscriber(this.kafkaReply, this.pluginsCfgService, this.aliSmsConfig));
            SMSResult smsResult = (SMSResult)msgContext.getAttr("SMS_RESULT");
            return BaseResult.success((Object)smsResult);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return BaseResult.error(null, (String)e.getMessage());
        }
    }

    @RequestMapping(value={"/test/send"})
    public BaseResult<SMSResult> testSend(@RequestBody String value) {
        return this.send0(value);
    }
}

