/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.voice.aliyun;

import com.aliyun.dyvmsapi20170525.Client;
import com.aliyun.dyvmsapi20170525.models.SingleCallByTtsRequest;
import com.aliyun.dyvmsapi20170525.models.SingleCallByTtsResponse;
import com.aliyun.dyvmsapi20170525.models.SingleCallByVoiceRequest;
import com.aliyun.dyvmsapi20170525.models.SingleCallByVoiceResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.VoiceMsg;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.bridge.voice.VoiceMessage;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.voice.aliyun.VoiceConfig;
import com.ovopark.messagehub.plugins.voice.aliyun.VoiceSender;
import com.ovopark.messagehub.sdk.model.Subs;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="VOICE")
@Component
public class SimpleVoiceSender
implements VoiceSender {
    private static final Logger log = LoggerFactory.getLogger(SimpleVoiceSender.class);
    @Autowired
    private VoiceConfig voiceConfig;

    @Override
    public MessageReply<?> send(VoiceMessage voiceMessage, MsgContext<VoiceMsg> msgMsgContext) {
        VoiceMsg msg = (VoiceMsg)msgMsgContext.msg();
        MessageReply success = MessageReply.success((Subs)Subs.VOICE, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{msg.getMsgId()});
        MessageReply fail = MessageReply.fail((Subs)Subs.VOICE, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[]{msg.getMsgId()});
        msgMsgContext.logger().info(log, " call number: " + voiceMessage.getCalledNumber());
        long start = System.currentTimeMillis();
        try {
            Client client = this.createClient();
            msgMsgContext.logger().info(log, " created client to aliyun cloud");
            if (Util.isNotEmpty((CharSequence)voiceMessage.getVoiceCode())) {
                msgMsgContext.logger().info(log, "use singleCallByVoice: " + voiceMessage.getVoiceCode());
                SingleCallByVoiceRequest singleCallByVoiceRequest = new SingleCallByVoiceRequest().setVoiceCode(voiceMessage.getVoiceCode()).setCalledShowNumber(voiceMessage.getCalledShowNumber()).setCalledNumber(voiceMessage.getCalledNumber()).setSpeed(Integer.valueOf(voiceMessage.getSpeed())).setVolume(Integer.valueOf(voiceMessage.getVolume())).setPlayTimes(Integer.valueOf(voiceMessage.getPlayTimes()));
                SingleCallByVoiceResponse singleCallByVoiceResponse = client.singleCallByVoiceWithOptions(singleCallByVoiceRequest, new RuntimeOptions());
                Integer statusCode = singleCallByVoiceResponse.getStatusCode();
                String requestId = singleCallByVoiceResponse.getBody().getRequestId();
                msgMsgContext.logger().info(log, "aliyun voice request id: " + requestId);
            } else {
                msgMsgContext.logger().info(log, "use singleCallByTts: " + voiceMessage.getTtsCode());
                SingleCallByTtsRequest singleCallByTtsRequest = new SingleCallByTtsRequest().setTtsCode(voiceMessage.getTtsCode()).setTtsParam(JSONAccessor.impl().format((Object)voiceMessage.getTtsParam())).setCalledShowNumber(voiceMessage.getCalledShowNumber()).setCalledNumber(voiceMessage.getCalledNumber()).setSpeed(Integer.valueOf(voiceMessage.getSpeed())).setVolume(Integer.valueOf(voiceMessage.getVolume())).setPlayTimes(Integer.valueOf(voiceMessage.getPlayTimes()));
                SingleCallByTtsResponse singleCallByTtsResponse = client.singleCallByTtsWithOptions(singleCallByTtsRequest, new RuntimeOptions());
                Integer statusCode = singleCallByTtsResponse.getStatusCode();
                String requestId = singleCallByTtsResponse.getBody().getRequestId();
                msgMsgContext.logger().info(log, "aliyun voice request id: " + requestId);
            }
            msgMsgContext.logger().info(log, "aliyun voice successfully, cost: " + Util.costTime((long)start));
            return success;
        }
        catch (Exception e) {
            msgMsgContext.logger().error(log, (Throwable)e, e.getMessage());
            fail.setDesc(e.getMessage());
            return fail;
        }
    }

    private Client createClient() throws Exception {
        Config config = new Config().setAccessKeyId(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID")).setAccessKeySecret(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"));
        config.endpoint = Optional.ofNullable(this.voiceConfig.endpoint()).orElse("dyvmsapi.aliyuncs.com");
        return new Client(config);
    }
}

