/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.redis;

import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.messagehub.redis.RateLimiter;
import com.ovopark.messagehub.redis.RateLimiterClient;
import com.ovopark.messagehub.redis.RateLimiterConf;
import com.ovopark.messagehub.redis.RedisRateLimiter;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedissonRateLimiterClient
implements RateLimiterClient {
    private static final CacheService<String, RateLimiter> RL = new CacheService.MapCacheService(true);
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public RateLimiter get(final String name) {
        return (RateLimiter)RL.putIfAbsentAndGet((Comparable)((Object)name), (Supplier)new Supplier<RateLimiter>(){

            @Override
            public RateLimiter get() {
                RRateLimiter rateLimiter = RedissonRateLimiterClient.this.redissonClient.getRateLimiter(name);
                RateLimiterConfig config = rateLimiter.getConfig();
                RateLimiterConf rateLimiterConf = new RateLimiterConf();
                rateLimiterConf.setRate(config.getRate());
                rateLimiterConf.setRateInterval(config.getRateInterval());
                rateLimiterConf.setTimeUnit(TimeUnit.MILLISECONDS);
                RedisRateLimiter redisRateLimiter = new RedisRateLimiter(name, rateLimiter, rateLimiterConf);
                return redisRateLimiter;
            }
        }, 15L, TimeUnit.SECONDS);
    }

    @Override
    public RateLimiter getOrCreate(String name, int ratePerSec) {
        RateLimiterConf rateLimiterConf = new RateLimiterConf();
        rateLimiterConf.setRate(ratePerSec);
        rateLimiterConf.setRateInterval(1L);
        rateLimiterConf.setTimeUnit(TimeUnit.SECONDS);
        return this.getOrCreate(name, rateLimiterConf);
    }

    @Override
    public RateLimiter getOrCreate(String name, RateLimiterConf rateLimiterConf) {
        return (RateLimiter)RL.putIfAbsentAndGet((Comparable)((Object)name), () -> {
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(name);
            RateLimiterConfig config = rateLimiter.getConfig();
            if (config == null) {
                RedisRateLimiter redisRateLimiter = new RedisRateLimiter(name, rateLimiter, rateLimiterConf);
                redisRateLimiter.setRate(rateLimiterConf.getRate(), rateLimiterConf.getRateInterval(), rateLimiterConf.getTimeUnit());
                return redisRateLimiter;
            }
            RateLimiterConf rlc = new RateLimiterConf();
            rlc.setRate(config.getRate());
            rlc.setRateInterval(config.getRateInterval());
            rlc.setTimeUnit(TimeUnit.MILLISECONDS);
            return new RedisRateLimiter(name, rateLimiter, rlc);
        }, 15L, TimeUnit.SECONDS);
    }

    @Override
    public RateLimiter upset(String name, RateLimiterConf rateLimiterConf) {
        return (RateLimiter)RL.updateAndGet((Comparable)((Object)name), old -> {
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(name);
            RedisRateLimiter redisRateLimiter = new RedisRateLimiter(name, rateLimiter, rateLimiterConf);
            redisRateLimiter.setRate(rateLimiterConf.getRate(), rateLimiterConf.getRateInterval(), rateLimiterConf.getTimeUnit());
            return redisRateLimiter;
        }, 15L, TimeUnit.SECONDS);
    }

    @Override
    public RateLimiter upset(String name, int ratePerSec) {
        RateLimiterConf rateLimiterConf = new RateLimiterConf();
        rateLimiterConf.setRate(ratePerSec);
        rateLimiterConf.setRateInterval(1L);
        rateLimiterConf.setTimeUnit(TimeUnit.SECONDS);
        return this.upset(name, rateLimiterConf);
    }

    @Override
    public RateLimiter setIfAbsent(String name, int ratePerSec) {
        RateLimiterConf rateLimiterConf = new RateLimiterConf();
        rateLimiterConf.setRate(ratePerSec);
        rateLimiterConf.setRateInterval(1L);
        rateLimiterConf.setTimeUnit(TimeUnit.SECONDS);
        return (RateLimiter)RL.updateAndGet((Comparable)((Object)name), old -> {
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(name);
            RedisRateLimiter redisRateLimiter = new RedisRateLimiter(name, rateLimiter, rateLimiterConf);
            boolean f = redisRateLimiter.trySetRate(rateLimiterConf.getRate(), rateLimiterConf.getRateInterval(), rateLimiterConf.getTimeUnit());
            if (!f) {
                return this.get(name);
            }
            return redisRateLimiter;
        }, 15L, TimeUnit.SECONDS);
    }
}

