/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.redis;

import com.ovopark.messagehub.redis.RateLimiter;
import com.ovopark.messagehub.redis.RateLimiterConf;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;

public class RedisRateLimiter
implements RateLimiter {
    private final String name;
    private final RRateLimiter rateLimiter;
    final RateLimiterConf rateLimiterConf;

    public RedisRateLimiter(String name, RRateLimiter rateLimiter, RateLimiterConf rateLimiterConf) {
        this.name = name;
        this.rateLimiter = rateLimiter;
        this.rateLimiterConf = rateLimiterConf;
    }

    boolean trySetRate(long rate, long rateInterval, TimeUnit rateIntervalUnit) {
        return this.rateLimiter.trySetRate(RateType.OVERALL, rate, TimeUnit.MILLISECONDS.convert(rateInterval, rateIntervalUnit), RateIntervalUnit.MILLISECONDS);
    }

    void setRate(long rate, long rateInterval, TimeUnit rateIntervalUnit) {
        this.rateLimiter.setRate(RateType.OVERALL, rate, TimeUnit.MILLISECONDS.convert(rateInterval, rateIntervalUnit), RateIntervalUnit.MILLISECONDS);
    }

    @Override
    public boolean tryAcquire(long permits, long timeout, TimeUnit unit) {
        if (permits > this.rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: " + this.rateLimiterConf.getRate() + " < " + permits);
        }
        return this.rateLimiter.tryAcquire(permits, timeout, unit);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return this.tryAcquire(1L, timeout, unit);
    }

    @Override
    public boolean tryAcquire(long permits) {
        if (permits > this.rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: " + this.rateLimiterConf.getRate() + " < " + permits);
        }
        return this.rateLimiter.tryAcquire(permits);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void acquire() {
        this.rateLimiter.acquire();
    }

    @Override
    public void acquire(long permits) {
        if (permits > this.rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: " + this.rateLimiterConf.getRate() + " < " + permits);
        }
        this.rateLimiter.acquire(permits);
    }

    @Override
    public void close() throws Exception {
    }
}

