/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.job;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.sdk.job.JobClientActive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class JobClientCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(JobClientCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation condition = metadata.getAnnotations().get(JobClientActive.class);
        if (!condition.isPresent()) {
            return true;
        }
        String activeJobClient = context.getEnvironment().getProperty("MESSAGEHUB_JOB_CLIENT_ACTIVE");
        if (Util.isEmpty((CharSequence)activeJobClient)) {
            log.warn("[off] inactive bean class: " + metadata.toString());
            return false;
        }
        if (activeJobClient.equalsIgnoreCase("on") || activeJobClient.equalsIgnoreCase("true")) {
            log.warn("[on|true] active bean class: " + metadata.toString());
            return true;
        }
        return false;
    }
}

