/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.job;

import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.sdk.job.ClientJobConfig;
import com.ovopark.messagehub.sdk.job.ClientNode;
import com.ovopark.messagehub.sdk.job.ClientNodeImpl;
import com.ovopark.messagehub.sdk.job.ClientNodeRegister;
import com.ovopark.messagehub.sdk.job.JobClientActive;
import java.net.InetAddress;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.messagehub.sdk.job.NacosNodeProvider")
public class NacosNodeProvider
implements ClientNodeRegister.ClientNodeProvider {
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private ClientJobConfig clientJobConfig;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${spring.application.name}")
    private String app;

    @Override
    public ClientNode clientNode() {
        int port;
        URI uri = this.serviceInstance.getUri();
        String registerIp = this.clientJobConfig.getIp();
        if (Util.isEmpty((CharSequence)registerIp)) {
            if (this.clientJobConfig.isUseNacosIp()) {
                registerIp = uri.getHost();
            } else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp = localAddress.getHostAddress();
            }
        }
        if (Util.isEmpty((CharSequence)registerIp)) {
            Util.log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        if ((port = this.clientJobConfig.getPort() > 0 ? this.clientJobConfig.getPort() : uri.getPort()) <= 0) {
            Util.log.error("cannot find port , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        ClientNodeImpl node = new ClientNodeImpl();
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(this.contextPath);
        node.setApp(this.app);
        return node;
    }
}

