package com.ovopark.messagehub.sdk.job;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotatedTypeMetadata;

import static com.ovopark.kernel.shared.Util.isEmpty;

@Slf4j
public class JobClientCondition implements Condition {


    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation<JobClientActive> condition = metadata.getAnnotations().get(JobClientActive.class);
        if (!condition.isPresent()) {
            return true;
        }

        //metadata.get
        String activeJobClient = context.getEnvironment().getProperty("MESSAGEHUB_JOB_CLIENT_ACTIVE");
        if (isEmpty(activeJobClient)) {
            log.warn("[off] inactive bean class: "+metadata.toString());
            return false;
        }

        if (activeJobClient.equalsIgnoreCase("on") || activeJobClient.equalsIgnoreCase("true")) {
            log.warn("[on|true] active bean class: "+metadata.toString());
            return true;
        }

        return false;
    }
}
