package com.ovopark.messagehub.sdk.job;

import com.ovopark.messagehub.sdk.internal.MessageHubJobApi;
import com.ovopark.messagehub.sdk.model.internal.job.TaskLogRequest;
import com.ovopark.messagehub.sdk.model.internal.job.TaskLogResponse;
import com.ovopark.module.shared.BaseResult;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class JobLogImpl extends com.ovopark.kernel.shared.vclient.JobLogImpl implements JobLog{

    public JobLogImpl(MessageHubJobApi messageHubJobApi, String traceId, long taskId) {
        super(JobLog.jobLogExecutor, taskLogRequest -> {
            BaseResult<TaskLogResponse> baseResult =
                    messageHubJobApi.log(((TaskLogRequest) taskLogRequest));
            if (baseResult==null || baseResult.getIsError()) {
                return null;
            }
            return baseResult.getData();
        },traceId,taskId,ClientNode.UUID_STR);
    }
}
