/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.job;

import com.ovopark.messagehub.sdk.job.BeanLookup;
import com.ovopark.messagehub.sdk.job.DelayTaskExecutor;
import com.ovopark.messagehub.sdk.job.DelayTaskListener;
import com.ovopark.messagehub.sdk.job.JobClientActive;
import com.ovopark.messagehub.sdk.job.JobLog;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class SimpleDelayTaskExecutor
implements DelayTaskExecutor {
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private BeanLookup beanLookup;
    final Map<String, DelayTaskListener> C = new ConcurrentHashMap<String, DelayTaskListener>();

    @Override
    public void execute(String uri, String args, JobLog jobLog) {
        URI u = URI.create(uri);
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            String beanName = u.getPath().substring(1);
            DelayTaskListener bean = this.C.computeIfAbsent(beanName, s -> {
                DelayTaskListener b = (DelayTaskListener)this.applicationContext.getBean(s);
                if (b == null) {
                    b = (DelayTaskListener)this.beanLookup.lookup((String)s);
                }
                return b;
            });
            bean.on(args, jobLog);
        }
    }
}

