package com.ovopark.messagehub.sdk.job;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JobClientActive
@Component
public class SimpleDelayTaskExecutor implements DelayTaskExecutor {

    @Autowired
    ApplicationContext applicationContext;

    @Autowired
    private BeanLookup beanLookup;

    final Map<String,DelayTaskListener> C=new ConcurrentHashMap<>();

    /*
    bean://spring/CRON_JOB_ClearDelayMsgListener
     */
    @Override
    public void execute(String uri, String args,JobLog jobLog) {

        URI u = URI.create(uri);
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            String beanName = u.getPath().substring(1);
            DelayTaskListener bean=C.computeIfAbsent(beanName, s -> {
                DelayTaskListener b = (DelayTaskListener) applicationContext.getBean(s);
                if (b==null) {
                    b=((DelayTaskListener) beanLookup.lookup(s));
                }
                return b;
            });
            bean.on(args,jobLog);
        }

    }


}
