/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.model;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.sdk.model.DDBuilderTrait;
import com.ovopark.messagehub.sdk.model.FSBuilderTrait;
import com.ovopark.messagehub.sdk.model.FloatBuilderTrait;
import com.ovopark.messagehub.sdk.model.GZHBuilderTrait;
import com.ovopark.messagehub.sdk.model.JGBuilderTrait;
import com.ovopark.messagehub.sdk.model.MCBuilderTrait;
import com.ovopark.messagehub.sdk.model.MailBuilderTrait;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.POPBuilderTrait;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.QWBuilderTrait;
import com.ovopark.messagehub.sdk.model.QWMessage;
import com.ovopark.messagehub.sdk.model.SMSBuilderTrait;
import com.ovopark.messagehub.sdk.model.SubBuilderTrait;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.TopBuilderTrait;
import com.ovopark.messagehub.sdk.model.WBSBuilderTrait;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public final class SubsBuilders {
    public static CompositeBuilder composite(String ruleId) {
        CompositeBuilder compositeBuilder = new CompositeBuilder();
        compositeBuilder.ruleId(ruleId);
        return compositeBuilder;
    }

    public static JGBuilder jg(String ruleId) {
        JGBuilder jgBuilder = new JGBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static MailBuilder mail(String ruleId) {
        MailBuilder jgBuilder = new MailBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static SMSBuilder sms(String ruleId) {
        SMSBuilder jgBuilder = new SMSBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static GZHBuilder gzh(String ruleId) {
        GZHBuilder jgBuilder = new GZHBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static QWBuilder qw(String ruleId) {
        QWBuilder jgBuilder = new QWBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static DDBuilder dd(String ruleId) {
        DDBuilder jgBuilder = new DDBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static FSBuilder fs(String ruleId) {
        FSBuilder jgBuilder = new FSBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static WBSBuilder wbs(String ruleId) {
        WBSBuilder jgBuilder = new WBSBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static WBSBuilder flightWBS() {
        WBSBuilder jgBuilder = new WBSBuilder();
        jgBuilder.ruleId("FLIGHT_WBS");
        return jgBuilder;
    }

    public static POPBuilder popWindow(String ruleId) {
        POPBuilder jgBuilder = new POPBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static FloatBuilder floatWindow(String ruleId) {
        FloatBuilder jgBuilder = new FloatBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static TopBuilder topWindow(String ruleId) {
        TopBuilder jgBuilder = new TopBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static MCBuilder mc(String ruleId) {
        MCBuilder jgBuilder = new MCBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    static Subs[] appendSub(Subs[] explicitSubs, Subs sub) {
        Subs[] subs = Optional.ofNullable(explicitSubs).orElse(new Subs[0]);
        Subs[] target = new Subs[subs.length + 1];
        System.arraycopy(subs, 0, target, 0, subs.length);
        target[target.length - 1] = sub;
        return target;
    }

    public static class CompositeBuilder
    extends SubBuilder<CompositeBuilder>
    implements MCBuilderTrait<CompositeBuilder> {
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public CompositeBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public CompositeBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public CompositeBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public CompositeBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public CompositeBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public CompositeBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public CompositeBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public CompositeBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public CompositeBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public CompositeBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        public JGBuilder jg() {
            return new JGBuilder();
        }

        public MailBuilder mail() {
            return new MailBuilder();
        }

        public SMSBuilder sms() {
            return new SMSBuilder();
        }

        public GZHBuilder gzh() {
            return new GZHBuilder();
        }

        public QWBuilder qw() {
            return new QWBuilder();
        }

        public DDBuilder dd() {
            return new DDBuilder();
        }

        public FSBuilder fs() {
            return new FSBuilder();
        }

        public WBSBuilder wbs() {
            return new WBSBuilder();
        }

        public POPBuilder popWindow() {
            return new POPBuilder();
        }

        public FloatBuilder floatWindow() {
            return new FloatBuilder();
        }

        public TopBuilder topWindow() {
            return new TopBuilder();
        }

        public MCBuilder mc() {
            return new MCBuilder();
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setMcAttach(this.mcAttach);
            return request;
        }

        public class JGBuilder
        extends JGBuilderBridge<JGBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setJgAttach(this.jgAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.JG));
                return CompositeBuilder.this;
            }
        }

        public class MailBuilder
        extends MailBuilderBridge<MailBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setMailAttach(this.mailAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.MAIL));
                return CompositeBuilder.this;
            }
        }

        public class SMSBuilder
        extends SMSBuilderBridge<SMSBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setSmsAttach(this.smsAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.SMS));
                return CompositeBuilder.this;
            }
        }

        public class GZHBuilder
        extends GZHBuilderBridge<GZHBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setGzhAttach(this.gzhAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.GZH));
                return CompositeBuilder.this;
            }
        }

        public class QWBuilder
        extends QWBuilderBridge<QWBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setQwAttach(this.qwAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.QW));
                return CompositeBuilder.this;
            }
        }

        public class DDBuilder
        extends DDBuilderBridge<DDBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setDdAttach(this.ddAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.DD));
                return CompositeBuilder.this;
            }
        }

        public class FSBuilder
        extends FSBuilderBridge<FSBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setFsAttach(this.fsAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.FS));
                return CompositeBuilder.this;
            }
        }

        public class WBSBuilder
        extends WBSBuilderBridge<WBSBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setWbsAttach(this.wbsAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.WBS));
                return CompositeBuilder.this;
            }
        }

        public class POPBuilder
        implements POPBuilderTrait<WindowBuilder<POPBuilder>> {
            MessageRequest.POPAttach popAttach = new MessageRequest.POPAttach();

            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setPopAttach(this.popAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.POP));
                return CompositeBuilder.this;
            }

            @Override
            public WindowBuilder<POPBuilder> newWindow() {
                return new WindowBuilder<POPBuilder>(this);
            }

            @Override
            public void append(MessageRequest.POPAttach.Window window) {
                this.popAttach.getWindowList().add(window);
            }
        }

        public class FloatBuilder
        extends FloatBuilderBridge<FloatBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setFloatAttach(this.floatAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.FLOAT));
                return CompositeBuilder.this;
            }
        }

        public class TopBuilder
        extends TopBuilderBridge<TopBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setTopAttach(this.topAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.TOP));
                return CompositeBuilder.this;
            }
        }

        public class MCBuilder {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.MC));
                return CompositeBuilder.this;
            }
        }
    }

    public static class SubBuilder<T extends SubBuilder<?>>
    implements SubBuilderTrait<T> {
        protected final MessageRequest messageRequest = new MessageRequest();

        @Override
        public T toUserIdList(List<Integer> toUserIdList) {
            this.messageRequest.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T sendUserId(Long sendUserId) {
            this.messageRequest.setSendUserId(sendUserId);
            return (T)this;
        }

        @Override
        public T ruleId(String ruleId) {
            this.messageRequest.setRuleId(ruleId);
            return (T)this;
        }

        @Override
        public T routing(String routing) {
            this.messageRequest.setRouting(routing);
            return (T)this;
        }

        @Override
        public T locale(Locale locale) {
            this.messageRequest.setLocale(locale);
            return (T)this;
        }

        @Override
        public T group(String group) {
            this.messageRequest.setGroup(group);
            return (T)this;
        }

        @Override
        public T from(String from) {
            this.messageRequest.setFrom(from);
            return (T)this;
        }

        @Override
        public T tagList(List<String> tagList) {
            this.messageRequest.setTagList(tagList);
            return (T)this;
        }

        public MessageRequest build() {
            if (Util.isEmpty((CharSequence)this.messageRequest.getRuleId())) {
                throw new RuntimeException("rule id is empty.");
            }
            return this.messageRequest;
        }
    }

    public static class JGBuilder
    extends SubBuilder<JGBuilder>
    implements JGBuilderTrait<JGBuilder>,
    MCBuilderTrait<JGBuilder> {
        final JGBuilderBridge jgBuilderBridge = new JGBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public JGBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public JGBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public JGBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public JGBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public JGBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public JGBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public JGBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public JGBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public JGBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public JGBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public JGBuilder messageBody(MessageBody messageBody) {
            this.jgBuilderBridge.messageBody(messageBody);
            return this;
        }

        @Override
        public JGBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.jgBuilderBridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public JGBuilder title(ParamContext title) {
            this.jgBuilderBridge.title(title);
            return this;
        }

        @Override
        public JGBuilder content(ParamContext content) {
            this.jgBuilderBridge.content(content);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.JG});
            MessageRequest.JGAttach attach = this.jgBuilderBridge.jgAttach;
            request.setJgAttach(attach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class MailBuilder
    extends SubBuilder<MailBuilder>
    implements MailBuilderTrait<MailBuilder>,
    MCBuilderTrait<MailBuilder> {
        MailBuilderBridge mailBuilderBridge = new MailBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public MailBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public MailBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public MailBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public MailBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public MailBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public MailBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public MailBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public MailBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public MailBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public MailBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public MailBuilder title(ParamContext title) {
            this.mailBuilderBridge.title(title);
            return this;
        }

        @Override
        public MailBuilder content(ParamContext content) {
            this.mailBuilderBridge.content(content);
            return this;
        }

        @Override
        public MailBuilder toMailAddressList(List<String> toMailAddressList) {
            this.mailBuilderBridge.toMailAddressList(toMailAddressList);
            return this;
        }

        @Override
        public MailBuilder ccMailAddressList(List<String> ccMailAddressList) {
            this.mailBuilderBridge.ccMailAddressList(ccMailAddressList);
            return this;
        }

        @Override
        public MailBuilder attachUrls(List<String> attachUrls) {
            this.mailBuilderBridge.attachUrls(attachUrls);
            return this;
        }

        @Override
        public MailBuilder fromAddress(String fromAddress) {
            this.mailBuilderBridge.fromAddress(fromAddress);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.MAIL});
            MessageRequest.MailAttach attach = this.mailBuilderBridge.mailAttach;
            request.setMailAttach(attach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class SMSBuilder
    extends SubBuilder<SMSBuilder>
    implements SMSBuilderTrait<SMSBuilder>,
    MCBuilderTrait<SMSBuilder> {
        SMSBuilderBridge bridge = new SMSBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public SMSBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public SMSBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public SMSBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public SMSBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public SMSBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public SMSBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public SMSBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public SMSBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public SMSBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public SMSBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public SMSBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.SMS});
            MessageRequest.SMSAttach smsAttach = this.bridge.smsAttach;
            request.setSmsAttach(smsAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class GZHBuilder
    extends SubBuilder<GZHBuilder>
    implements GZHBuilderTrait<GZHBuilder>,
    MCBuilderTrait<GZHBuilder> {
        GZHBuilderBridge bridge = new GZHBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public GZHBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public GZHBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public GZHBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public GZHBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public GZHBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public GZHBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public GZHBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public GZHBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public GZHBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public GZHBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public GZHBuilder gzhTemplateId(String gzhTemplateId) {
            this.bridge.gzhTemplateId(gzhTemplateId);
            return this;
        }

        @Override
        public GZHBuilder paramContext(ParamContext paramContext) {
            this.bridge.paramContext(paramContext);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.GZH});
            MessageRequest.GZHAttach gzhAttach = this.bridge.gzhAttach;
            request.setGzhAttach(gzhAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class QWBuilder
    extends SubBuilder<QWBuilder>
    implements QWBuilderTrait<QWBuilder>,
    MCBuilderTrait<QWBuilder> {
        QWBuilderBridge bridge = new QWBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public QWBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public QWBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public QWBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public QWBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public QWBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public QWBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public QWBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public QWBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public QWBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public QWBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public QWBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.bridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public QWBuilder qwMessage(QWMessage qwMessage) {
            this.bridge.qwMessage(qwMessage);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.QW});
            MessageRequest.QWAttach qwAttach = this.bridge.qwAttach;
            request.setQwAttach(qwAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class DDBuilder
    extends SubBuilder<DDBuilder>
    implements DDBuilderTrait<DDBuilder>,
    MCBuilderTrait<DDBuilder> {
        DDBuilderBridge bridge = new DDBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public DDBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public DDBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public DDBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public DDBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public DDBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public DDBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public DDBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public DDBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public DDBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public DDBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public DDBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.bridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public DDBuilder qwMessage(QWMessage qwMessage) {
            this.bridge.qwMessage(qwMessage);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.DD});
            MessageRequest.DDAttach ddAttach = this.bridge.ddAttach;
            request.setDdAttach(ddAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class FSBuilder
    extends SubBuilder<FSBuilder>
    implements FSBuilderTrait<FSBuilder>,
    MCBuilderTrait<FSBuilder> {
        FSBuilderBridge bridge = new FSBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public FSBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public FSBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public FSBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public FSBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public FSBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public FSBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public FSBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public FSBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public FSBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public FSBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public FSBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.bridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public FSBuilder qwMessage(QWMessage qwMessage) {
            this.bridge.qwMessage(qwMessage);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.FS});
            MessageRequest.FSAttach fsAttach = this.bridge.fsAttach;
            request.setFsAttach(fsAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class WBSBuilder
    extends SubBuilder<WBSBuilder>
    implements WBSBuilderTrait<WBSBuilder>,
    MCBuilderTrait<WBSBuilder> {
        WBSBuilderBridge bridge = new WBSBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public WBSBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public WBSBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public WBSBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public WBSBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public WBSBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public WBSBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public WBSBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public WBSBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public WBSBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public WBSBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public WBSBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public WBSBuilder connection(String connection) {
            this.bridge.connection(connection);
            return this;
        }

        @Override
        public WBSBuilder user(Integer ... userList) {
            this.bridge.user(userList);
            return this;
        }

        @Override
        public WBSBuilder mac(String ... macList) {
            this.bridge.mac(macList);
            return this;
        }

        @Override
        public WBSBuilder group(String ... groupList) {
            this.bridge.group(groupList);
            return this;
        }

        @Override
        public WBSBuilder group(MessageRequest.GroupPath groupPath) {
            this.bridge.group(groupPath);
            return this;
        }

        @Override
        public WBSBuilder client(String ... clientList) {
            this.bridge.client(clientList);
            return this;
        }

        @Override
        public WBSBuilder messageType(String messageType) {
            this.bridge.messageType(messageType);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.WBS});
            MessageRequest.WBSAttach wbsAttach = this.bridge.wbsAttach;
            request.setWbsAttach(wbsAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class POPBuilder
    extends SubBuilder<POPBuilder>
    implements POPBuilderTrait<WindowBuilder<POPBuilder>>,
    MCBuilderTrait<POPBuilder> {
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();
        MessageRequest.POPAttach popAttach = new MessageRequest.POPAttach();

        @Override
        public POPBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public POPBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public POPBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public POPBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public POPBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public POPBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public POPBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public POPBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public POPBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public POPBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public WindowBuilder<POPBuilder> newWindow() {
            return new WindowBuilder<POPBuilder>(this);
        }

        @Override
        public void append(MessageRequest.POPAttach.Window window) {
            this.popAttach.getWindowList().add(window);
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.POP});
            request.setPopAttach(this.popAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class FloatBuilder
    extends SubBuilder<FloatBuilder>
    implements FloatBuilderTrait<FloatBuilder>,
    MCBuilderTrait<FloatBuilder> {
        FloatBuilderBridge bridge = new FloatBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public FloatBuilder title(ParamContext title) {
            this.bridge.title(title);
            return this;
        }

        @Override
        public FloatBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public FloatBuilder icon(String icon) {
            this.bridge.icon(icon);
            return this;
        }

        @Override
        public FloatBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public FloatBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public FloatBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public FloatBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public FloatBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public FloatBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public FloatBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public FloatBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public FloatBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public FloatBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.FLOAT});
            MessageRequest.FloatAttach floatAttach = this.bridge.floatAttach;
            request.setFloatAttach(floatAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class TopBuilder
    extends SubBuilder<TopBuilder>
    implements TopBuilderTrait<TopBuilder>,
    MCBuilderTrait<TopBuilder> {
        TopBuilderBridge bridge = new TopBuilderBridge();
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public TopBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public TopBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public TopBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public TopBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public TopBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public TopBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public TopBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public TopBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public TopBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public TopBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public TopBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.FLOAT});
            MessageRequest.TopAttach topAttach = this.bridge.topAttach;
            request.setTopAttach(topAttach);
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class MCBuilder
    extends SubBuilder<MCBuilder>
    implements MCBuilderTrait<MCBuilder> {
        MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        @Override
        public MCBuilder mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return this;
        }

        @Override
        public MCBuilder mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return this;
        }

        @Override
        public MCBuilder mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return this;
        }

        @Override
        public MCBuilder mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return this;
        }

        @Override
        public MCBuilder mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return this;
        }

        @Override
        public MCBuilder mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return this;
        }

        @Override
        public MCBuilder mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return this;
        }

        @Override
        public MCBuilder mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return this;
        }

        @Override
        public MCBuilder mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return this;
        }

        @Override
        public MCBuilder mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(new Subs[]{Subs.MC});
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }

    public static class JGBuilderBridge<T>
    implements JGBuilderTrait<T> {
        final MessageRequest.JGAttach jgAttach = new MessageRequest.JGAttach();

        @Override
        public T title(ParamContext title) {
            this.jgAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.jgAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T messageBody(MessageBody messageBody) {
            this.jgAttach.setMessageBody(messageBody);
            return (T)this;
        }

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.jgAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }
    }

    public static class MailBuilderBridge<T>
    implements MailBuilderTrait<T> {
        final MessageRequest.MailAttach mailAttach = new MessageRequest.MailAttach();

        @Override
        public T title(ParamContext title) {
            this.mailAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.mailAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T toMailAddressList(List<String> toMailAddressList) {
            this.mailAttach.setToMailAddressList(toMailAddressList);
            return (T)this;
        }

        @Override
        public T ccMailAddressList(List<String> ccMailAddressList) {
            this.mailAttach.setCcMailAddressList(ccMailAddressList);
            return (T)this;
        }

        @Override
        public T attachUrls(List<String> attachUrls) {
            this.mailAttach.setAttachUrls(attachUrls);
            return (T)this;
        }

        @Override
        public T fromAddress(String fromAddress) {
            this.mailAttach.setFromAddress(fromAddress);
            return (T)this;
        }
    }

    public static class GZHBuilderBridge<T>
    implements GZHBuilderTrait<T> {
        MessageRequest.GZHAttach gzhAttach = new MessageRequest.GZHAttach();

        @Override
        public T gzhTemplateId(String gzhTemplateId) {
            this.gzhAttach.setGzhTemplateId(gzhTemplateId);
            return (T)this;
        }

        @Override
        public T paramContext(ParamContext paramContext) {
            this.gzhAttach.setParamContext(paramContext);
            return (T)this;
        }
    }

    public static class DDBuilderBridge<T>
    implements DDBuilderTrait<T> {
        MessageRequest.DDAttach ddAttach = new MessageRequest.DDAttach();

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.ddAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T qwMessage(QWMessage qwMessage) {
            this.ddAttach.setQwMessage(qwMessage);
            return (T)this;
        }
    }

    public static class FSBuilderBridge<T>
    implements FSBuilderTrait<T> {
        MessageRequest.FSAttach fsAttach = new MessageRequest.FSAttach();

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.fsAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T qwMessage(QWMessage qwMessage) {
            this.fsAttach.setQwMessage(qwMessage);
            return (T)this;
        }
    }

    public static class QWBuilderBridge<T>
    implements QWBuilderTrait<T> {
        MessageRequest.QWAttach qwAttach = new MessageRequest.QWAttach();

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.qwAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T qwMessage(QWMessage qwMessage) {
            this.qwAttach.setQwMessage(qwMessage);
            return (T)this;
        }
    }

    public static class WBSBuilderBridge<T>
    implements WBSBuilderTrait<T> {
        MessageRequest.WBSAttach wbsAttach = new MessageRequest.WBSAttach();

        @Override
        public T content(ParamContext content) {
            this.wbsAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T connection(String connection) {
            this.wbsAttach.setConnection(connection);
            return (T)this;
        }

        @Override
        public T user(Integer ... userList) {
            this.wbsAttach.user(userList);
            return (T)this;
        }

        @Override
        public T mac(String ... macList) {
            this.wbsAttach.mac(macList);
            return (T)this;
        }

        @Override
        public T group(String ... groupList) {
            this.wbsAttach.group(groupList);
            return (T)this;
        }

        @Override
        public T group(MessageRequest.GroupPath groupPath) {
            this.wbsAttach.group(groupPath.build().toArray(new String[0]));
            return (T)this;
        }

        @Override
        public T client(String ... clientList) {
            this.wbsAttach.getClients().addAll(Arrays.asList(clientList));
            return (T)this;
        }

        @Override
        public T messageType(String messageType) {
            this.wbsAttach.setMessageType(messageType);
            return (T)this;
        }
    }

    public static class WindowBuilder<C extends POPBuilderTrait<?>>
    implements POPBuilderTrait.WindowBuilderTrait<WindowBuilder<C>> {
        MessageRequest.POPAttach.Window window = new MessageRequest.POPAttach.Window();
        final C popBuilderTrait;

        public WindowBuilder(C popBuilderTrait) {
            this.popBuilderTrait = popBuilderTrait;
        }

        @Override
        public WindowBuilder<C> title(ParamContext title) {
            this.window.setTitle(title);
            return this;
        }

        @Override
        public WindowBuilder<C> pic(String pic) {
            this.window.setPic(pic);
            return this;
        }

        @Override
        public WindowBuilder<C> content(ParamContext content) {
            this.window.setContent(content);
            return this;
        }

        public C ok() {
            this.popBuilderTrait.append(this.window);
            return this.popBuilderTrait;
        }
    }

    public static class FloatBuilderBridge<T>
    implements FloatBuilderTrait<T> {
        MessageRequest.FloatAttach floatAttach = new MessageRequest.FloatAttach();

        @Override
        public T title(ParamContext title) {
            this.floatAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.floatAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T icon(String icon) {
            this.floatAttach.setIcon(icon);
            return (T)this;
        }
    }

    public static class SMSBuilderBridge<T>
    implements SMSBuilderTrait<T> {
        MessageRequest.SMSAttach smsAttach = new MessageRequest.SMSAttach();

        @Override
        public T content(ParamContext content) {
            this.smsAttach.setContent(content);
            return (T)this;
        }
    }

    public static class TopBuilderBridge<T>
    implements TopBuilderTrait<T> {
        MessageRequest.TopAttach topAttach = new MessageRequest.TopAttach();

        @Override
        public T content(ParamContext content) {
            this.topAttach.setContent(content);
            return (T)this;
        }
    }
}

