/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.model;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.sdk.model.FloatBuilderTrait;
import com.ovopark.messagehub.sdk.model.GZHBuilderTrait;
import com.ovopark.messagehub.sdk.model.JGBuilderTrait;
import com.ovopark.messagehub.sdk.model.MCBuilderTrait;
import com.ovopark.messagehub.sdk.model.MailBuilderTrait;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.POPBuilderTrait;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SMSBuilderTrait;
import com.ovopark.messagehub.sdk.model.SubBuilderTrait;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.ThirdBuilderTrait;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.TopBuilderTrait;
import com.ovopark.messagehub.sdk.model.VoiceBuilderTrait;
import com.ovopark.messagehub.sdk.model.WBSBuilderTrait;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SubsBuilders {
    public static CompositeBuilder composite(String ruleId) {
        CompositeBuilder compositeBuilder = new CompositeBuilder();
        compositeBuilder.ruleId(ruleId);
        return compositeBuilder;
    }

    public static JGBuilder jg(String ruleId) {
        JGBuilder jgBuilder = new JGBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static MailBuilder mail(String ruleId) {
        MailBuilder jgBuilder = new MailBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static SMSBuilder sms(String ruleId) {
        SMSBuilder jgBuilder = new SMSBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static GZHBuilder gzh(String ruleId) {
        GZHBuilder jgBuilder = new GZHBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static ThirdBuilder third(String ruleId) {
        ThirdBuilder jgBuilder = new ThirdBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static WBSBuilder wbs(String ruleId) {
        WBSBuilder jgBuilder = new WBSBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static WBSBuilder flightWBS() {
        WBSBuilder jgBuilder = new WBSBuilder();
        jgBuilder.ruleId("FLIGHT_WBS");
        return jgBuilder;
    }

    public static POPBuilder popWindow(String ruleId) {
        POPBuilder jgBuilder = new POPBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static FloatBuilder floatWindow(String ruleId) {
        FloatBuilder jgBuilder = new FloatBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static TopBuilder topWindow(String ruleId) {
        TopBuilder jgBuilder = new TopBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static MCBuilder mc(String ruleId) {
        MCBuilder jgBuilder = new MCBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    public static VoiceBuilder voice(String ruleId) {
        VoiceBuilder jgBuilder = new VoiceBuilder();
        jgBuilder.ruleId(ruleId);
        return jgBuilder;
    }

    static Subs[] appendSub(Subs[] explicitSubs, Subs ... sub) {
        Subs[] subs = Optional.ofNullable(explicitSubs).orElse(new Subs[0]);
        int pre = subs.length;
        Subs[] target = new Subs[subs.length + sub.length];
        System.arraycopy(subs, 0, target, 0, subs.length);
        System.arraycopy(sub, 0, target, pre, sub.length);
        Subs[] array = Arrays.stream(target).distinct().collect(Collectors.toList()).toArray(new Subs[0]);
        return array;
    }

    public static class CompositeBuilder
    extends MCBuilder0<CompositeBuilder>
    implements MCBuilderTrait<CompositeBuilder> {
        public JGBuilder jg() {
            return new JGBuilder();
        }

        public MailBuilder mail() {
            return new MailBuilder();
        }

        public SMSBuilder sms() {
            return new SMSBuilder();
        }

        public GZHBuilder gzh() {
            return new GZHBuilder();
        }

        public ThirdBuilder third() {
            return new ThirdBuilder();
        }

        public WBSBuilder wbs() {
            return new WBSBuilder();
        }

        public POPBuilder popWindow() {
            return new POPBuilder();
        }

        public FloatBuilder floatWindow() {
            return new FloatBuilder();
        }

        public TopBuilder topWindow() {
            return new TopBuilder();
        }

        public VoiceBuilder voice() {
            return new VoiceBuilder();
        }

        public MCBuilder mc() {
            return new MCBuilder();
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            return request;
        }

        public class JGBuilder
        extends JGBuilderBridge<JGBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setJgAttach(this.jgAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.JG));
                return CompositeBuilder.this;
            }
        }

        public class MailBuilder
        extends MailBuilderBridge<MailBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setMailAttach(this.mailAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.MAIL));
                if (this.mailAttach.contentType == null) {
                    throw new RuntimeException("mail content type is empty.");
                }
                return CompositeBuilder.this;
            }
        }

        public class SMSBuilder
        extends SMSBuilderBridge<SMSBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setSmsAttach(this.smsAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.SMS));
                return CompositeBuilder.this;
            }
        }

        public class GZHBuilder
        extends GZHBuilderBridge<GZHBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setGzhAttach(this.gzhAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.GZH));
                return CompositeBuilder.this;
            }
        }

        public class ThirdBuilder
        extends ThirdBuilderBridge<ThirdBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setThirdAttach(this.thirdAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.QW, Subs.DD, Subs.FS));
                return CompositeBuilder.this;
            }
        }

        public class WBSBuilder
        extends WBSBuilderBridge<WBSBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setWbsAttach(this.wbsAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.WBS));
                return CompositeBuilder.this;
            }
        }

        public class POPBuilder
        implements POPBuilderTrait<WindowBuilder<POPBuilder>> {
            MessageRequest.POPAttach popAttach = new MessageRequest.POPAttach();

            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setPopAttach(this.popAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.POP));
                return CompositeBuilder.this;
            }

            @Override
            public WindowBuilder<POPBuilder> newWindow() {
                return new WindowBuilder<POPBuilder>(this);
            }

            @Override
            public void append(MessageRequest.POPAttach.Window window) {
                this.popAttach.getWindowList().add(window);
            }
        }

        public class FloatBuilder
        extends FloatBuilderBridge<FloatBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setFloatAttach(this.floatAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.FLOAT));
                return CompositeBuilder.this;
            }
        }

        public class TopBuilder
        extends TopBuilderBridge<TopBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setTopAttach(this.topAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.TOP));
                return CompositeBuilder.this;
            }
        }

        public class VoiceBuilder
        extends VoiceBuilderBridge<VoiceBuilder> {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setVoiceAttach(this.voiceAttach);
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.VOICE));
                return CompositeBuilder.this;
            }
        }

        public class MCBuilder {
            public CompositeBuilder ok() {
                CompositeBuilder.this.messageRequest.setExplicitSubs(SubsBuilders.appendSub(CompositeBuilder.this.messageRequest.getExplicitSubs(), Subs.MC));
                return CompositeBuilder.this;
            }
        }
    }

    public static class SubBuilder<T extends SubBuilder<?>>
    implements SubBuilderTrait<T> {
        protected final MessageRequest messageRequest = new MessageRequest();

        @Override
        public T toUserIdList(List<Integer> toUserIdList) {
            this.messageRequest.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T sendUserId(Long sendUserId) {
            this.messageRequest.setSendUserId(sendUserId);
            return (T)this;
        }

        @Override
        public T ruleId(String ruleId) {
            this.messageRequest.setRuleId(ruleId);
            return (T)this;
        }

        @Override
        public T routing(String routing) {
            this.messageRequest.setRouting(routing);
            return (T)this;
        }

        @Override
        public T locale(Locale locale) {
            this.messageRequest.setLocale(locale);
            return (T)this;
        }

        @Override
        public T group(String group) {
            this.messageRequest.setGroup(group);
            return (T)this;
        }

        @Override
        public T from(String from) {
            this.messageRequest.setFrom(from);
            return (T)this;
        }

        @Override
        public T tagList(List<String> tagList) {
            this.messageRequest.setTagList(tagList);
            return (T)this;
        }

        public MessageRequest build() {
            if (Util.isEmpty((CharSequence)this.messageRequest.getRuleId())) {
                throw new RuntimeException("rule id is empty.");
            }
            return this.messageRequest;
        }
    }

    public static class JGBuilder
    extends MCBuilder0<JGBuilder>
    implements JGBuilderTrait<JGBuilder>,
    MCBuilderTrait<JGBuilder> {
        final JGBuilderBridge bridge = new JGBuilderBridge();

        @Override
        public JGBuilder messageBody(MessageBody messageBody) {
            this.bridge.messageBody(messageBody);
            return this;
        }

        @Override
        public JGBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.bridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public JGBuilder title(ParamContext title) {
            this.bridge.title(title);
            return this;
        }

        @Override
        public JGBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public JGBuilder title(String templateKey, ParamContext title) {
            this.bridge.title(templateKey, title);
            return this;
        }

        @Override
        public JGBuilder content(String templateKey, ParamContext content) {
            this.bridge.content(templateKey, content);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.JG));
            MessageRequest.JGAttach attach = this.bridge.jgAttach;
            request.setJgAttach(attach);
            return request;
        }
    }

    public static class MailBuilder
    extends MCBuilder0<MailBuilder>
    implements MailBuilderTrait<MailBuilder>,
    MCBuilderTrait<MailBuilder> {
        MailBuilderBridge bridge = new MailBuilderBridge();

        @Override
        public MailBuilder title(String templateKey, ParamContext title) {
            this.bridge.title(templateKey, title);
            return this;
        }

        @Override
        public MailBuilder content(String templateKey, ParamContext content) {
            this.bridge.content(templateKey, content);
            return this;
        }

        @Override
        public MailBuilder title(ParamContext title) {
            this.bridge.title(title);
            return this;
        }

        @Override
        public MailBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public MailBuilder toMailAddressList(List<String> toMailAddressList) {
            this.bridge.toMailAddressList(toMailAddressList);
            return this;
        }

        @Override
        public MailBuilder ccMailAddressList(List<String> ccMailAddressList) {
            this.bridge.ccMailAddressList(ccMailAddressList);
            return this;
        }

        @Override
        public MailBuilder attachUrls(List<String> attachUrls) {
            this.bridge.attachUrls(attachUrls);
            return this;
        }

        @Override
        @Deprecated
        public MailBuilder fromAddress(String fromAddress) {
            this.bridge.fromAddress(fromAddress);
            return this;
        }

        @Override
        public MailBuilder contentType(MessageRequest.MailAttach.ContentType contentType) {
            this.bridge.contentType(contentType);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.MAIL));
            MessageRequest.MailAttach attach = this.bridge.mailAttach;
            request.setMailAttach(attach);
            if (attach.contentType == null) {
                throw new RuntimeException("mail content type is empty.");
            }
            return request;
        }
    }

    public static class SMSBuilder
    extends MCBuilder0<SMSBuilder>
    implements SMSBuilderTrait<SMSBuilder>,
    MCBuilderTrait<SMSBuilder> {
        SMSBuilderBridge bridge = new SMSBuilderBridge();

        @Override
        public SMSBuilder appId(String appId) {
            this.bridge.appId(appId);
            return this;
        }

        @Override
        public SMSBuilder phoneList(List<String> phoneList) {
            this.bridge.phoneList(phoneList);
            return this;
        }

        @Override
        public SMSBuilder templateId(String templateId) {
            this.bridge.templateId(templateId);
            return this;
        }

        @Override
        public SMSBuilder args(String[] args) {
            this.bridge.args(args);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.SMS));
            MessageRequest.SMSAttach smsAttach = this.bridge.smsAttach;
            request.setSmsAttach(smsAttach);
            return request;
        }
    }

    public static class GZHBuilder
    extends MCBuilder0<GZHBuilder>
    implements GZHBuilderTrait<GZHBuilder>,
    MCBuilderTrait<GZHBuilder> {
        GZHBuilderBridge bridge = new GZHBuilderBridge();

        @Override
        public GZHBuilder gzhTemplateId(String gzhTemplateId) {
            this.bridge.gzhTemplateId(gzhTemplateId);
            return this;
        }

        @Override
        public GZHBuilder paramContext(ParamContext paramContext) {
            this.bridge.paramContext(paramContext);
            return this;
        }

        @Override
        public GZHBuilder url(String url) {
            this.bridge.url(url);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.GZH));
            MessageRequest.GZHAttach gzhAttach = this.bridge.gzhAttach;
            request.setGzhAttach(gzhAttach);
            return request;
        }
    }

    public static class ThirdBuilder
    extends MCBuilder0<ThirdBuilder>
    implements ThirdBuilderTrait<ThirdBuilder>,
    MCBuilderTrait<ThirdBuilder> {
        ThirdBuilderBridge bridge = new ThirdBuilderBridge();

        @Override
        public ThirdBuilder overrideToUserIdList(List<Integer> toUserIdList) {
            this.bridge.overrideToUserIdList(toUserIdList);
            return this;
        }

        @Override
        public ThirdBuilder thirdMessage(ThirdMessage thirdMessage) {
            this.bridge.thirdMessage(thirdMessage);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.QW, Subs.DD, Subs.FS));
            MessageRequest.ThirdAttach thirdAttach = this.bridge.thirdAttach;
            request.setThirdAttach(thirdAttach);
            return request;
        }
    }

    public static class WBSBuilder
    extends MCBuilder0<WBSBuilder>
    implements WBSBuilderTrait<WBSBuilder>,
    MCBuilderTrait<WBSBuilder> {
        WBSBuilderBridge bridge = new WBSBuilderBridge();

        @Override
        public WBSBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public WBSBuilder content(String templateKey, ParamContext content) {
            this.bridge.content(templateKey, content);
            return this;
        }

        @Override
        public WBSBuilder connection(String connection) {
            this.bridge.connection(connection);
            return this;
        }

        @Override
        public WBSBuilder user(Integer ... userList) {
            this.bridge.user(userList);
            return this;
        }

        @Override
        public WBSBuilder mac(String ... macList) {
            this.bridge.mac(macList);
            return this;
        }

        @Override
        public WBSBuilder group(String ... groupList) {
            this.bridge.group(groupList);
            return this;
        }

        @Override
        public WBSBuilder group(MessageRequest.GroupPath groupPath) {
            this.bridge.group(groupPath);
            return this;
        }

        @Override
        public WBSBuilder client(String ... clientList) {
            this.bridge.client(clientList);
            return this;
        }

        @Override
        public WBSBuilder messageType(String messageType) {
            this.bridge.messageType(messageType);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.WBS));
            MessageRequest.WBSAttach wbsAttach = this.bridge.wbsAttach;
            request.setWbsAttach(wbsAttach);
            return request;
        }
    }

    public static class POPBuilder
    extends MCBuilder0<POPBuilder>
    implements POPBuilderTrait<WindowBuilder<POPBuilder>>,
    MCBuilderTrait<POPBuilder> {
        MessageRequest.POPAttach popAttach = new MessageRequest.POPAttach();

        @Override
        public WindowBuilder<POPBuilder> newWindow() {
            return new WindowBuilder<POPBuilder>(this);
        }

        @Override
        public void append(MessageRequest.POPAttach.Window window) {
            this.popAttach.getWindowList().add(window);
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.POP));
            request.setPopAttach(this.popAttach);
            return request;
        }
    }

    public static class FloatBuilder
    extends MCBuilder0<FloatBuilder>
    implements FloatBuilderTrait<FloatBuilder>,
    MCBuilderTrait<FloatBuilder> {
        FloatBuilderBridge bridge = new FloatBuilderBridge();

        @Override
        public FloatBuilder title(String templateKey, ParamContext title) {
            this.bridge.title(templateKey, title);
            return this;
        }

        @Override
        public FloatBuilder content(String templateKey, ParamContext content) {
            this.bridge.content(templateKey, content);
            return this;
        }

        @Override
        public FloatBuilder title(ParamContext title) {
            this.bridge.title(title);
            return this;
        }

        @Override
        public FloatBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public FloatBuilder icon(String icon) {
            this.bridge.icon(icon);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.FLOAT));
            MessageRequest.FloatAttach floatAttach = this.bridge.floatAttach;
            request.setFloatAttach(floatAttach);
            return request;
        }
    }

    public static class TopBuilder
    extends MCBuilder0<TopBuilder>
    implements TopBuilderTrait<TopBuilder>,
    MCBuilderTrait<TopBuilder> {
        TopBuilderBridge bridge = new TopBuilderBridge();

        @Override
        public TopBuilder content(ParamContext content) {
            this.bridge.content(content);
            return this;
        }

        @Override
        public TopBuilder content(String templateKey, ParamContext content) {
            this.bridge.content(templateKey, content);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.FLOAT));
            MessageRequest.TopAttach topAttach = this.bridge.topAttach;
            request.setTopAttach(topAttach);
            return request;
        }
    }

    public static class MCBuilder
    extends MCBuilder0<MCBuilder>
    implements MCBuilderTrait<MCBuilder> {
    }

    public static class VoiceBuilder
    extends MCBuilder0<VoiceBuilder>
    implements VoiceBuilderTrait<VoiceBuilder>,
    MCBuilderTrait<VoiceBuilder> {
        VoiceBuilderBridge bridge = new VoiceBuilderBridge();

        @Override
        public VoiceBuilder volume(int volume) {
            this.bridge.volume(volume);
            return this;
        }

        @Override
        public VoiceBuilder speed(int speed) {
            this.bridge.speed(speed);
            return this;
        }

        @Override
        public VoiceBuilder calledNumberList(List<String> calledNumberList) {
            this.bridge.calledNumberList(calledNumberList);
            return this;
        }

        @Override
        public VoiceBuilder calledShowNumber(String calledShowNumber) {
            this.bridge.calledShowNumber(calledShowNumber);
            return this;
        }

        @Override
        public VoiceBuilder playTimes(int playTimes) {
            this.bridge.playTimes(playTimes);
            return this;
        }

        @Override
        public VoiceBuilder ttsParam(ParamContext ttsParam) {
            this.bridge.ttsParam(ttsParam);
            return this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.VOICE));
            MessageRequest.VoiceAttach voiceAttach = this.bridge.voiceAttach;
            request.setVoiceAttach(voiceAttach);
            return request;
        }
    }

    public static class VoiceBuilderBridge<T>
    implements VoiceBuilderTrait<T> {
        MessageRequest.VoiceAttach voiceAttach = new MessageRequest.VoiceAttach();

        @Override
        public T volume(int volume) {
            this.voiceAttach.setVolume(volume);
            return (T)this;
        }

        @Override
        public T speed(int speed) {
            this.voiceAttach.setSpeed(speed);
            return (T)this;
        }

        @Override
        public T calledNumberList(List<String> calledNumberList) {
            this.voiceAttach.setCalledNumberList(calledNumberList);
            return (T)this;
        }

        @Override
        public T calledShowNumber(String calledShowNumber) {
            this.voiceAttach.setCalledShowNumber(calledShowNumber);
            return (T)this;
        }

        @Override
        public T playTimes(int playTimes) {
            this.voiceAttach.setPlayTimes(playTimes);
            return (T)this;
        }

        @Override
        public T ttsParam(ParamContext ttsParam) {
            this.voiceAttach.setTtsParam(ttsParam);
            return (T)this;
        }
    }

    public static class JGBuilderBridge<T>
    implements JGBuilderTrait<T> {
        final MessageRequest.JGAttach jgAttach = new MessageRequest.JGAttach();

        @Override
        public T title(String templateKey, ParamContext title) {
            this.jgAttach.setTitleTemplateKey(templateKey);
            this.jgAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(String templateKey, ParamContext content) {
            this.jgAttach.setContentTemplateKey(templateKey);
            this.jgAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T title(ParamContext title) {
            this.jgAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.jgAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T messageBody(MessageBody messageBody) {
            this.jgAttach.setMessageBody(messageBody);
            return (T)this;
        }

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.jgAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }
    }

    public static class MailBuilderBridge<T>
    implements MailBuilderTrait<T> {
        final MessageRequest.MailAttach mailAttach = new MessageRequest.MailAttach();

        @Override
        public T title(String templateKey, ParamContext title) {
            this.mailAttach.setTitleTemplateKey(templateKey);
            this.mailAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(String templateKey, ParamContext content) {
            this.mailAttach.setContentTemplateKey(templateKey);
            this.mailAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T title(ParamContext title) {
            this.mailAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.mailAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T toMailAddressList(List<String> toMailAddressList) {
            this.mailAttach.setToMailAddressList(toMailAddressList);
            return (T)this;
        }

        @Override
        public T ccMailAddressList(List<String> ccMailAddressList) {
            this.mailAttach.setCcMailAddressList(ccMailAddressList);
            return (T)this;
        }

        @Override
        public T attachUrls(List<String> attachUrls) {
            this.mailAttach.setAttachUrls(attachUrls);
            return (T)this;
        }

        @Override
        @Deprecated
        public T fromAddress(String fromAddress) {
            this.mailAttach.setFromAddress(fromAddress);
            return (T)this;
        }

        @Override
        public T contentType(MessageRequest.MailAttach.ContentType contentType) {
            this.mailAttach.setContentType(contentType);
            return (T)this;
        }
    }

    public static class GZHBuilderBridge<T>
    implements GZHBuilderTrait<T> {
        MessageRequest.GZHAttach gzhAttach = new MessageRequest.GZHAttach();

        @Override
        public T gzhTemplateId(String gzhTemplateId) {
            this.gzhAttach.setGzhTemplateId(gzhTemplateId);
            return (T)this;
        }

        @Override
        public T paramContext(ParamContext paramContext) {
            this.gzhAttach.setParamContext(paramContext);
            return (T)this;
        }

        @Override
        public T url(String url) {
            this.gzhAttach.setUrl(url);
            return (T)this;
        }
    }

    public static class ThirdBuilderBridge<T>
    implements ThirdBuilderTrait<T> {
        MessageRequest.ThirdAttach thirdAttach = new MessageRequest.ThirdAttach();

        @Override
        public T overrideToUserIdList(List<Integer> toUserIdList) {
            this.thirdAttach.setToUserIdList(toUserIdList);
            return (T)this;
        }

        @Override
        public T thirdMessage(ThirdMessage thirdMessage) {
            this.thirdAttach.setThirdMessage(thirdMessage);
            return (T)this;
        }
    }

    public static class WBSBuilderBridge<T>
    implements WBSBuilderTrait<T> {
        MessageRequest.WBSAttach wbsAttach = new MessageRequest.WBSAttach();

        @Override
        public T content(ParamContext content) {
            this.wbsAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T content(String templateKey, ParamContext content) {
            this.wbsAttach.setTemplateKey(templateKey);
            this.wbsAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T connection(String connection) {
            this.wbsAttach.setConnection(connection);
            return (T)this;
        }

        @Override
        public T user(Integer ... userList) {
            this.wbsAttach.user(userList);
            return (T)this;
        }

        @Override
        public T mac(String ... macList) {
            this.wbsAttach.mac(macList);
            return (T)this;
        }

        @Override
        public T group(String ... groupList) {
            this.wbsAttach.group(groupList);
            return (T)this;
        }

        @Override
        public T group(MessageRequest.GroupPath groupPath) {
            this.wbsAttach.group(groupPath.build().toArray(new String[0]));
            return (T)this;
        }

        @Override
        public T client(String ... clientList) {
            this.wbsAttach.getClients().addAll(Arrays.asList(clientList));
            return (T)this;
        }

        @Override
        public T messageType(String messageType) {
            this.wbsAttach.setMessageType(messageType);
            return (T)this;
        }
    }

    public static class WindowBuilder<C extends POPBuilderTrait<?>>
    implements POPBuilderTrait.WindowBuilderTrait<WindowBuilder<C>> {
        MessageRequest.POPAttach.Window window = new MessageRequest.POPAttach.Window();
        final C popBuilderTrait;

        public WindowBuilder(C popBuilderTrait) {
            this.popBuilderTrait = popBuilderTrait;
        }

        @Override
        public WindowBuilder<C> title(String templateKey, ParamContext title) {
            this.window.setTitleTemplateKey(templateKey);
            this.window.setTitle(title);
            return this;
        }

        @Override
        public WindowBuilder<C> content(String templateKey, ParamContext content) {
            this.window.setContentTemplateKey(templateKey);
            this.window.setContent(content);
            return this;
        }

        @Override
        public WindowBuilder<C> title(ParamContext title) {
            this.window.setTitle(title);
            return this;
        }

        @Override
        public WindowBuilder<C> pic(String pic) {
            this.window.setPic(pic);
            return this;
        }

        @Override
        public WindowBuilder<C> content(ParamContext content) {
            this.window.setContent(content);
            return this;
        }

        public C ok() {
            this.popBuilderTrait.append(this.window);
            return this.popBuilderTrait;
        }
    }

    public static class FloatBuilderBridge<T>
    implements FloatBuilderTrait<T> {
        MessageRequest.FloatAttach floatAttach = new MessageRequest.FloatAttach();

        @Override
        public T title(String templateKey, ParamContext title) {
            this.floatAttach.setTitleTemplateKey(templateKey);
            this.floatAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(String templateKey, ParamContext content) {
            this.floatAttach.setContentTemplateKey(templateKey);
            this.floatAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T title(ParamContext title) {
            this.floatAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T content(ParamContext content) {
            this.floatAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T icon(String icon) {
            this.floatAttach.setIcon(icon);
            return (T)this;
        }
    }

    public static class SMSBuilderBridge<T>
    implements SMSBuilderTrait<T> {
        MessageRequest.SMSAttach smsAttach = new MessageRequest.SMSAttach();

        @Override
        public T appId(String appId) {
            this.smsAttach.setAppId(appId);
            return (T)this;
        }

        @Override
        public T phoneList(List<String> phoneList) {
            this.smsAttach.setPhoneList(phoneList);
            return (T)this;
        }

        @Override
        public T templateId(String templateId) {
            this.smsAttach.setTemplateId(templateId);
            return (T)this;
        }

        @Override
        public T args(String[] args) {
            this.smsAttach.setArgs(args);
            return (T)this;
        }
    }

    public static class TopBuilderBridge<T>
    implements TopBuilderTrait<T> {
        MessageRequest.TopAttach topAttach = new MessageRequest.TopAttach();

        @Override
        public T content(ParamContext content) {
            this.topAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T content(String templateKey, ParamContext content) {
            this.topAttach.setContentTemplateKey(templateKey);
            this.topAttach.setContent(content);
            return (T)this;
        }
    }

    static class MCBuilder0<T extends MCBuilder0<?>>
    extends SubBuilder<T>
    implements MCBuilderTrait<T> {
        private MessageRequest.MCAttach mcAttach = new MessageRequest.MCAttach();

        MCBuilder0() {
        }

        @Override
        public T mcTitle(String templateKey, ParamContext title) {
            this.mcAttach.setTitleTemplateKey(templateKey);
            this.mcAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T mcContent(String templateKey, ParamContext content) {
            this.mcAttach.setContentTemplateKey(templateKey);
            this.mcAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T mcTitle(ParamContext title) {
            this.mcAttach.setTitle(title);
            return (T)this;
        }

        @Override
        public T mcContent(ParamContext content) {
            this.mcAttach.setContent(content);
            return (T)this;
        }

        @Override
        public T mcPic(String pic) {
            this.mcAttach.setPic(pic);
            return (T)this;
        }

        @Override
        public T mcHidden(boolean hidden) {
            this.mcAttach.setHidden(hidden ? 1 : 0);
            return (T)this;
        }

        @Override
        public T mcRefId(String refId) {
            this.mcAttach.setRefId(refId);
            return (T)this;
        }

        @Override
        public T mcJsonData(String jsonData) {
            this.mcAttach.setJsonData(jsonData);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcCategory(String category) {
            this.mcAttach.setCategory(category);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcObjectType(String objectType) {
            this.mcAttach.setObjectType(objectType);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcObjectId(Long objectId) {
            this.mcAttach.setObjectId(objectId);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcObjectIds(String objectIds) {
            this.mcAttach.setObjectIds(objectIds);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcSubId(Long subId) {
            this.mcAttach.setSubId(subId);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcI18nKey(String i18nKey) {
            this.mcAttach.setI18nKey(i18nKey);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcI18nParam(String i18nParam) {
            this.mcAttach.setI18nParam(i18nParam);
            return (T)this;
        }

        @Override
        @Deprecated
        public T mcDescription(String description) {
            this.mcAttach.setDescription(description);
            return (T)this;
        }

        @Override
        public MessageRequest build() {
            MessageRequest request = super.build();
            request.setExplicitSubs(SubsBuilders.appendSub(request.getExplicitSubs(), Subs.MC));
            request.setMcAttach(this.mcAttach);
            return request;
        }
    }
}

