/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.model;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ToUserGroup {
    public String build();

    public static ToUserGroup user(Integer ... userList) {
        return new ToUserGroupBuilder().user(userList);
    }

    public static ToUserGroup dept(Integer ... deptList) {
        return new ToUserGroupBuilder().dept(deptList);
    }

    public static ToUserGroup enterprise(Integer ... enterpriseList) {
        return new ToUserGroupBuilder().enterprise(enterpriseList);
    }

    public static class ToUserGroupBuilder
    implements ToUserGroup {
        private String group;

        @Override
        ToUserGroupBuilder user(Integer ... userList) {
            this.group = "user://" + Stream.of(userList).map(String::valueOf).collect(Collectors.joining(","));
            return this;
        }

        @Override
        ToUserGroupBuilder dept(Integer ... deptList) {
            this.group = "dept://" + Stream.of(deptList).map(String::valueOf).collect(Collectors.joining(","));
            return this;
        }

        @Override
        ToUserGroupBuilder enterprise(Integer ... enterpriseList) {
            this.group = "enterprise://" + Stream.of(enterpriseList).map(String::valueOf).collect(Collectors.joining(","));
            return this;
        }

        @Override
        public String build() {
            return this.group;
        }
    }
}

