/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk.model.internal;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.Node;
import com.ovopark.messagehub.sdk.model.internal.PluginsService;
import com.ovopark.messagehub.sdk.model.internal.ThreadCache;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class PluginsManager {
    private static final PluginsManager INSTANCE = new PluginsManager();
    private static final CacheService.MapCacheService<Subs, Plugin> plugins = new CacheService.MapCacheService(false);

    private PluginsManager() {
    }

    public static PluginsManager getOrCreate() {
        return INSTANCE;
    }

    public void register(Subs subs, PluginsService pluginsService) {
        plugins.updateAndGet((Comparable)((Object)subs), plugin -> {
            if (plugin == null) {
                plugin = new Plugin();
                plugin.setSubs(subs);
                plugin.setPluginsService(pluginsService);
                Util.schedule((ScheduledExecutorService)ThreadCache.scheduled, () -> {
                    Plugin p = (Plugin)plugins.get((Comparable)((Object)subs));
                    Node node = new Node();
                    node.setId(subs.getName() + ":" + pluginsService.nodeId());
                    node.setNodeId(pluginsService.nodeId());
                    node.setIp(pluginsService.ip());
                    node.setType("plugins");
                    node.setTime(LocalDateTime.now());
                    node.setMeta(p.getMeta());
                    pluginsService.heartbeat(node);
                }, (long)1L, (TimeUnit)TimeUnit.MINUTES, e -> true, () -> true);
            }
            return plugin;
        });
    }

    public void heartbeat(Subs subs, Map<String, Object> meta) {
        plugins.updateAndGet((Comparable)((Object)subs), plugin -> {
            if (plugin == null) {
                throw new RuntimeException("subs must be registered first, call register(...)???: " + (Object)((Object)subs));
            }
            plugin.setHeartbeatTime(System.currentTimeMillis());
            ((Plugin)plugin).updated.incrementAndGet();
            plugin.setMeta(meta);
            return plugin;
        });
    }

    public void heartbeat(Subs subs) {
        plugins.updateAndGet((Comparable)((Object)subs), plugin -> {
            if (plugin == null) {
                throw new RuntimeException("subs must be registered first.");
            }
            plugin.setHeartbeatTime(System.currentTimeMillis());
            ((Plugin)plugin).updated.incrementAndGet();
            return plugin;
        });
    }

    static class Plugin {
        Subs subs;
        PluginsService pluginsService;
        private long heartbeatTime;
        private Map<String, Object> meta;
        private AtomicLong updated = new AtomicLong(0L);

        public Subs getSubs() {
            return this.subs;
        }

        public PluginsService getPluginsService() {
            return this.pluginsService;
        }

        public long getHeartbeatTime() {
            return this.heartbeatTime;
        }

        public Map<String, Object> getMeta() {
            return this.meta;
        }

        public AtomicLong getUpdated() {
            return this.updated;
        }

        public void setSubs(Subs subs) {
            this.subs = subs;
        }

        public void setPluginsService(PluginsService pluginsService) {
            this.pluginsService = pluginsService;
        }

        public void setHeartbeatTime(long heartbeatTime) {
            this.heartbeatTime = heartbeatTime;
        }

        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        public void setUpdated(AtomicLong updated) {
            this.updated = updated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plugin)) {
                return false;
            }
            Plugin other = (Plugin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeartbeatTime() != other.getHeartbeatTime()) {
                return false;
            }
            Subs this$subs = this.getSubs();
            Subs other$subs = other.getSubs();
            if (this$subs == null ? other$subs != null : !((Object)((Object)this$subs)).equals((Object)other$subs)) {
                return false;
            }
            PluginsService this$pluginsService = this.getPluginsService();
            PluginsService other$pluginsService = other.getPluginsService();
            if (this$pluginsService == null ? other$pluginsService != null : !this$pluginsService.equals(other$pluginsService)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            AtomicLong this$updated = this.getUpdated();
            AtomicLong other$updated = other.getUpdated();
            return !(this$updated == null ? other$updated != null : !this$updated.equals(other$updated));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Plugin;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $heartbeatTime = this.getHeartbeatTime();
            result = result * 59 + (int)($heartbeatTime >>> 32 ^ $heartbeatTime);
            Subs $subs = this.getSubs();
            result = result * 59 + ($subs == null ? 43 : ((Object)((Object)$subs)).hashCode());
            PluginsService $pluginsService = this.getPluginsService();
            result = result * 59 + ($pluginsService == null ? 43 : $pluginsService.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            AtomicLong $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : $updated.hashCode());
            return result;
        }

        public String toString() {
            return "PluginsManager.Plugin(subs=" + (Object)((Object)this.getSubs()) + ", pluginsService=" + this.getPluginsService() + ", heartbeatTime=" + this.getHeartbeatTime() + ", meta=" + this.getMeta() + ", updated=" + this.getUpdated() + ")";
        }
    }
}

