package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.kafka.UserMessageModel;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

import static com.ovopark.kernel.shared.Util.compare2;

@Slf4j
public class SendMsg2OtherChannelSubscriber extends CoreSubscriber<Send2ThirdProcessor.UserMessageContext> {

    final private List<Send2ThirdProcessor> send2ThirdProcessorList;

    final private MessageHubV2Api messageHubV2Api;

    final private boolean skipHidden;

    public SendMsg2OtherChannelSubscriber(List<Send2ThirdProcessor> send2ThirdProcessorList, MessageHubV2Api messageHubV2Api) {
        this(send2ThirdProcessorList,messageHubV2Api,true);
    }

    public SendMsg2OtherChannelSubscriber(List<Send2ThirdProcessor> send2ThirdProcessorList, MessageHubV2Api messageHubV2Api,boolean skipHidden) {
        this.send2ThirdProcessorList = send2ThirdProcessorList;
        this.messageHubV2Api=messageHubV2Api;
        this.skipHidden = skipHidden;
    }

    public SendMsg2OtherChannelSubscriber(Send2ThirdProcessor send2ThirdProcessor, MessageHubV2Api messageHubV2Api) {
        this(Collections.singletonList(send2ThirdProcessor),messageHubV2Api,true);
    }

    public SendMsg2OtherChannelSubscriber(Send2ThirdProcessor send2ThirdProcessor, MessageHubV2Api messageHubV2Api,boolean skipHidden) {
        this(Collections.singletonList(send2ThirdProcessor),messageHubV2Api,skipHidden);
    }

    public static Stream<Send2ThirdProcessor.UserMessageContext> from(UserMessageModel userMessageModel){
        return Stream.from(userMessageModel)
                .map(Send2ThirdProcessor.UserMessageContext::from);
    }

    @Override
    public void onNext(Send2ThirdProcessor.UserMessageContext userMessageContext) {
        UserMessageModel userMessageModel = userMessageContext.message();
        if (skipHidden && userMessageModel.getHidden()==1) {
            return;
        }

        // 没配置企业，直接返回
        if (userMessageModel.getGroupId() == null) {
            return;
        }

        Send2ThirdProcessor.UserMessageContext.SimpleUserMessageContext simpleUserMessageContext =
                (Send2ThirdProcessor.UserMessageContext.SimpleUserMessageContext) userMessageContext;
        simpleUserMessageContext.setMessageHubV2Api(messageHubV2Api);

        ThirdMessage thirdMessage = userMessageModel.getThirdMessage();
        Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp;
        if (thirdMessage==null) {
            typeTmp=typeTmp(null, userMessageModel.getMsgTypeCode(), null);
        }
        else {
            typeTmp=typeTmp(thirdMessage.getCategory(),thirdMessage.getObjectType(),thirdMessage);
        }

        simpleUserMessageContext.setTypeTmp(typeTmp);

        for (Send2ThirdProcessor send2ThirdProcessor : send2ThirdProcessorList) {
            send2ThirdProcessor.send(userMessageContext);
        }

    }


    private Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp(String category, String objectType, ThirdMessage thirdMessage){
        Send2ThirdProcessor.UserMessageContext.TypeTmp typeTmp= new Send2ThirdProcessor.UserMessageContext.TypeTmp();
        String sourceModule=null;
        //待办单
        if("Problem_Capture_Notify".equalsIgnoreCase(objectType)){
            sourceModule= "待办单";
        }

        //待办单
        else if("Problem_FeedBack_Notify".equalsIgnoreCase(objectType)){
            sourceModule= "待办单";
        }

        //巡店审核
        else if("TEMP_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)){
            sourceModule= "巡店审核";
        }

        //巡店记录
        else if("FINAL_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)){
            sourceModule= "巡店记录";
        }

        //计划巡店
        else if("TYPE_STORE_PLAN_SYSTEM".equalsIgnoreCase(category)){
            sourceModule= "计划巡店";
        }

        //巡店报告(订阅)
        else if("CHECK_REPORT_SUBSCRIPTION_NOTIFY".equalsIgnoreCase(objectType)){
            sourceModule= "巡店报告(订阅)";
        }

        //巡店报告(订阅) 实时
        else if("CHECK_REPORT_REAL_TIME_NOTIFY".equalsIgnoreCase(objectType)){
            sourceModule= "巡店报告(订阅) 实时";
        }

//        //报告待审核
//        else if("REPORT_WAIT_CHECK".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //报告审核通过
//        else if("REPORT_CHECK_PASS".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //报告通知
//        else if("REPORT_CHECK_PASS_LIST".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //任务
//        else if("TYPE_TASK_SYSTEM".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //AI提醒
//        else if("AI_CHECK_AUDIT_NOTIFY".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }

        //我的考试
        else if("TYPE_PAPER_SYSTEM".equalsIgnoreCase(objectType)){
            sourceModule= "我的考试";
        }

        //计划巡店
        else if("INSPECTION_PLAN".equalsIgnoreCase(objectType)){
            sourceModule= "计划巡店";
        }

        //计划巡店
        else if("CHECK_AUDIT".equalsIgnoreCase(objectType)){
            sourceModule= "计划巡店";
        }

        //门店自检
        //现场巡店
        else if("CHECK_TASK_REMIND_NOTIFY".equalsIgnoreCase(objectType) && "FINAL_CHECK_REPORT\n".equalsIgnoreCase(category) ){
            if (thirdMessage!=null && compare2(thirdMessage.getMainType(),0)==0) {
                sourceModule= "现场巡店";
            }
            else if (thirdMessage!=null && compare2(thirdMessage.getMainType(),1)==0) {
                sourceModule= "远程巡店\n";
            }
            else if (thirdMessage!=null && compare2(thirdMessage.getMainType(),12)==0) {
                sourceModule= "门店自检";
            }
            else {
                sourceModule= "巡店";
            }

        }

        //企业课程
        else if("TYPE_TRAINING_NEW_SYSTEM".equalsIgnoreCase(objectType)){
            sourceModule= "企业课程";
        }

        //企业课程
        else if("TYPE_TRAINING_SYSTEM".equalsIgnoreCase(objectType)){
            sourceModule= "企业课程";
        }

        //巡店审核
        else if("REFUSE_CHECK_REPORT_NOTIFY".equalsIgnoreCase(objectType)){
            sourceModule= "巡店审核";
        }

        //协同提醒
        else if("Problem_Remind".equalsIgnoreCase(objectType)){
            sourceModule= "协同提醒";
        }

        //催办提醒
        else if("Problem_Urging_Remind".equalsIgnoreCase(objectType)){
            sourceModule= "催办提醒";
        }

        //协同巡店
        else if("COORDINATE_CHECK_INVITE".equalsIgnoreCase(objectType)){
            sourceModule= "协同巡店";
        }

        //待办单提醒
        else if("Problem_Remind_Merge".equalsIgnoreCase(objectType)){
            sourceModule= "待办单提醒";
        }

        //待办单
        else if("Problem_Cc_Merge".equalsIgnoreCase(objectType)){
            sourceModule= "待办单";
        }

        //培训计划
        else if("TYPE_COURSE_SYSTEM".equalsIgnoreCase(objectType)){
            sourceModule= "巡店审核";
        }

        //知识上新
        else if("TYPE_MATERIAL_SYSTEM".equalsIgnoreCase(objectType)){
            sourceModule= "知识上新";
        }
//        //培训计划
//        else if("TYPE_COURSE_SCH_OBJ_TYPE".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//        //阅卷提醒
//        else if("TYPE_TRAINING_PAPER_REVIEWER".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }

        //催办提醒
        else if("APPROVAL_URGING_REMIND".equalsIgnoreCase(objectType)){
            sourceModule= "催办提醒";
        }

//        //实操考评变更
//        else if("TYPE_OPEADD_EXAMINER_TYPE".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //实操考评变更
//        else if("TYPE_OPEADD_USER_TYPE".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //实操考评变更
//        else if("TYPE_OPEUP_EXAMINER_TYPE".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }
//
//        //实操考评变更
//        else if("TYPE_OPEUP_USER_TYPE".equalsIgnoreCase(objectType)){
//            sourceModule= "巡店审核";
//        }

        //计划巡店
        else if("DISPLAY_PLAN".equalsIgnoreCase(objectType)){
            sourceModule= "巡店审核";
        }

        //计划巡店
        else if("Device_Alert_Notify_Off".equalsIgnoreCase(objectType)){
            sourceModule= "掉线告警";
        }

        else {
            typeTmp.setBreakProcess(true);
        }

        typeTmp.setSourceModule(sourceModule);
        return typeTmp;
    }


}
