package com.ovopark.messagehub.sdk.internal;


import com.ovopark.messagehub.sdk.model.internal.WorkerNode;
import com.ovopark.messagehub.sdk.model.internal.delay.AssignedShard;
import com.ovopark.messagehub.sdk.model.internal.delay.NodeView;
import com.ovopark.messagehub.sdk.model.internal.job.AppNodeList;
import com.ovopark.messagehub.sdk.model.internal.job.ClientNodeRegisterRequest;
import com.ovopark.messagehub.sdk.model.internal.job.ClientNodeRegisterResponse;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@FeignClient(value = "messagehub-master"
//        ,url = "127.0.0.1:13760"
        ,url = "${messagehub.control.master.url:127.0.0.1:13760}"
)
public interface MessageHubMasterApi {

    @PostMapping("/messagehub-master/feign/delay/shard/nodeView")
    BaseResult<AssignedShard> nodeView(@RequestBody NodeView nodeView);

    @RequestMapping("/messagehub-master/feign/delay/shard/lease")
    BaseResult<Boolean> lease(@RequestParam("nodeName")  String nodeName, @RequestParam("group")  String group);

    @RequestMapping("/messagehub-master/feign/delay/shard/worker")
    BaseResult<List<WorkerNode>> worker();

    @GetMapping("/messagehub-master/feign/cronJob/jobClient/getAppNode")
    BaseResult<AppNodeList> getAppNode(@RequestParam("app") String app);

    @PostMapping("/messagehub-master/feign/cronJob/jobClient/heartbeat")
    BaseResult<ClientNodeRegisterResponse> heartbeat(@RequestBody ClientNodeRegisterRequest clientNodeRegisterRequest);

    @GetMapping("/messagehub-master/assist/cluster/shard/check")
    BaseResult<Map<String,Object>> check();

}
