package com.ovopark.messagehub.sdk.internal;


import com.ovopark.messagehub.sdk.model.internal.job.*;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface MessageHubJobApi {

    @PostMapping("/messagehub-control/feign/delay/cronJob/jobClient/heartbeat")
    BaseResult<ClientNodeRegisterResponse> heartbeat(@RequestBody ClientNodeRegisterRequest clientNodeRegisterRequest);

    @PostMapping("/messagehub-control/feign/delay/cronJob/jobClient/lockClient")
    BaseResult<TaskLockResponse> lockClient(@RequestBody TaskLockRequest taskLockRequest);

    @PostMapping("/messagehub-control/feign/delay/cronJob/jobClient/log")
    BaseResult<TaskLogResponse> log(@RequestBody TaskLogRequest taskLogRequest);

    @PostMapping("/messagehub-control/feign/delay/cronJob/jobClient/saveCronTask")
    BaseResult<CronTaskSaveResponse> saveCronTask(@RequestBody CronTaskSaveRequest cronTaskSaveRequest);

}
