package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.MessageModel;
import com.ovopark.messagehub.sdk.model.migrate.SDKMessageQuery;
import com.ovopark.messagehub.sdk.model.migrate.MessageClassifyPo;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface MessageMigrateApi {

    @PostMapping("/messagehub-control/feign/message/migrate/queryAll")
    BaseResult<List<MessageModel>> queryAll(@RequestBody SDKMessageQuery sdkMessageQuery);

    @PostMapping("/messagehub-control/feign/message/migrate/searchOnce")
    BaseResult<List<MessageModel>> searchOnce(@RequestBody SDKMessageQuery sdkMessageQuery);

    @PostMapping("/messagehub-control/feign/message/migrate/delete")
    BaseResult<List<String>> delete(@RequestBody List<String> ids);

    @PostMapping("/messagehub-control/feign/message/migrate/deleteAndSendWBS")
    BaseResult<Boolean> deleteAndSendWBS(@RequestBody SDKMessageQuery sdkMessageQuery);

    @PostMapping("/messagehub-control/feign/message/migrate/updateMessage")
    BaseResult<Boolean> updateMessage(@RequestBody List<MessageModel> messageModelList);

    @PostMapping("/messagehub-control/feign/message/migrate/getMsgCount")
    BaseResult<Long> getMsgCount(@RequestParam("objectType") String objectType
            , @RequestParam("userId") Integer userId
            , @RequestParam("readFlag") int readFlag);

    @PostMapping("/messagehub-control/feign/message/migrate/getUndoneMessage")
    BaseResult<List<MessageClassifyPo>> getUndoneMessage(
            @RequestParam("userId") Integer userId
            , @RequestParam("groupId") Integer groupId);

    @PostMapping("/messagehub-control/feign/message/migrate/getUndoneMessageByType")
    public BaseResult<List<MessageClassifyPo>> getUndoneMessageByType(
            @RequestParam("userId") Integer userId
            , @RequestParam("groupId") Integer groupId
            , @RequestParam("objectTypeList") List<String> objectTypeList);
    @PostMapping("/messagehub-control/feign/message/migrate/getUnDoStorePlanMsg")
    public BaseResult<List<MessageModel>> getUnDoStorePlanMsg(@RequestBody SDKMessageQuery sdkMessageQuery);

    @PostMapping("/messagehub-control/feign/message/migrate/updateReadFlagNumId")
    BaseResult<Boolean> updateReadFlagNumId( @RequestParam("numId") Long numId);

    @PostMapping("/messagehub-control/feign/message/migrate/updateReadFlag")
    public BaseResult<Boolean> updateReadFlag( @RequestParam("userId") Integer userId
            , @RequestParam("groupId") Integer groupId
            , @RequestParam("category") String category
            , @RequestParam("objectType") String objectType
    );

    @PostMapping("/messagehub-control/feign/message/migrate/deleteNumId")
    public BaseResult<Boolean> deleteNumId(@RequestBody List<Integer> numIds);


    @PostMapping("/messagehub-control/feign/message/migrate/getUndoneMessageByClassify")
    public BaseResult<List<MessageModel>> getUndoneMessageByClassify(@RequestBody SDKMessageQuery sdkMessageQuery);

    @GetMapping("/messagehub-control/feign/message/migrate/getMessageByNumId")
    public BaseResult<MessageModel> getMessageByNumId(@RequestParam("numId") Long numId);

    @GetMapping("/messagehub-control/feign/message/migrate/getMessagesByObjPage")
    public BaseResult<List<MessageModel>> getMessagesByObjPage(@RequestParam("objectType") String objectType
            , @RequestParam(value = "objectId",required = false) Long objectId
            , @RequestParam("userId") Integer userId
            , @RequestParam("pageNumber") long pageNumber
            , @RequestParam("pageSize") int pageSize);

    @PostMapping("/messagehub-control/feign/message/migrate/deleteMessageByNumId")
    public BaseResult<Boolean> deleteMessageByNumId(@RequestParam("numId") Long numId);

    static String ruleId(String category, String objectType){
        if ("TYPE_FORM_CLOUD".equals(category)) {
            return "TYPE_FORM_CLOUD_MCXXX";
        }
        return objectType;

    }



}
