package com.ovopark.messagehub.sdk;

import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.messagehub.sdk.model.TodoMessageTagGetRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageTagGetResponse;
import com.ovopark.messagehub.sdk.model.TodoMessageTagSaveRequest;
import com.ovopark.module.shared.BaseResult;

import java.util.concurrent.TimeUnit;

import static com.ovopark.kernel.shared.Util.isEmpty;
import static com.ovopark.kernel.shared.Util.md5;

class SimpleTodoMsgTagService implements TodoMsgTagService{

    final TodoMessageV2Api todoMessageV2Api;

    final static KVEngine.TtlFunc<String> ttlFunc= KVEngine.newTtl(SimpleTodoMsgTagService.class.getName());

    public SimpleTodoMsgTagService(TodoMessageV2Api todoMessageV2Api) {
        this.todoMessageV2Api = todoMessageV2Api;
    }

    @Override
    public String get(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        String c = orderStr(category, objectType, targetUserId, objectId, others);
        String md5 = md5(c);
        KVEngine.PutResult<String, String> putResult = ttlFunc.putIfAbsentAndGet(md5, s -> {

            TodoMessageTagGetRequest todoMessageTagGetRequest=new TodoMessageTagGetRequest();
            todoMessageTagGetRequest.setMd5(md5);
            BaseResult<TodoMessageTagGetResponse> baseResult = todoMessageV2Api.getTag(todoMessageTagGetRequest);
            if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null
                    || !baseResult.getData().isSuccess()
            ) {
                throw new IllegalArgumentException("cannot get tag("+md5+"): "+c);
            }
            String tag = baseResult.getData().getTag();
            if (isEmpty(tag)) {
                throw new IllegalArgumentException("cannot get tag("+md5+"): "+c);
            }
            return tag;
        }, 60, TimeUnit.MINUTES);

        return putResult.value();
    }

    private static String orderStr(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        /*
        1. category
        2. objectType , null convert to "null"
        3. targetUserId, null convert to "null"
        4. objectId, null convert to "null"
        5. each element of array,  null convert to "null"; if the arg self is null or empty , ignore
        --- cannot change the order , otherwise the md5 is changed important!!!
         */
        String c= category +"|"+ objectType +"|"+ targetUserId +"|"+ objectId;
        if (others != null) {
            for (String o : others) {
                c += "|" + o;
            }
        }
        return c;
    }

    @Override
    public String upsert(String category, String objectType, Integer targetUserId, Long objectId, String[] others, String content) {
        String c = orderStr(category, objectType, targetUserId, objectId, others);
        String md5 = md5(c);

        String finalC = c;
        KVEngine.PutResult<String, String> putResult = ttlFunc.putIfAbsentAndGet(md5, s -> {

            TodoMessageTagGetRequest todoMessageTagGetRequest=new TodoMessageTagGetRequest();
            todoMessageTagGetRequest.setMd5(md5);

            BaseResult<TodoMessageTagGetResponse> baseResult = todoMessageV2Api.getTag(todoMessageTagGetRequest);

            if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null
                    || !baseResult.getData().isSuccess()
            ) {
                throw new IllegalArgumentException("cannot get tag("+md5+"): "+ finalC);
            }
            String tag = baseResult.getData().getTag();
            if (isEmpty(tag)) {
                TodoMessageTagSaveRequest todoMessageTagSaveRequest=new TodoMessageTagSaveRequest();
                todoMessageTagSaveRequest.setMd5(md5);
                todoMessageTagSaveRequest.setContent(content);
                BaseResult<TodoMessageTagGetResponse> b = todoMessageV2Api.upsertTag(todoMessageTagSaveRequest);
                if (b==null || b.getIsError() || b.getData()==null || !b.getData().isSuccess()
                ) {
                    throw new IllegalArgumentException("cannot get tag("+md5+"): "+ finalC);
                }

                tag = b.getData().getTag();
                if (isEmpty(tag)) {
                    throw new IllegalArgumentException("cannot get tag("+md5+"): "+ finalC);
                }
            }
            return tag;
        }, 60, TimeUnit.MINUTES);

        return putResult.value();


    }


}
