package com.ovopark.messagehub.sdk;

import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.internal.MessageHubSyncCnfApi;
import com.ovopark.messagehub.sdk.model.internal.SyncConfImpl;
import com.ovopark.module.shared.BaseResult;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;

public class SyncConfRPC implements Stream.DBEntrySupplier.SyncConfFsync {

    @Autowired
    private MessageHubSyncCnfApi messageHubSyncCnfApi;

    @Override
    public void fsync(String syncId, String syncTime, String syncPk,int syncCount, String syncStatus) {
        fsyncWithVcc(-1,syncId,syncTime,syncPk,syncCount,syncStatus);
    }

    @Override
    public long fsyncWithVcc(long ver, String syncId, String syncTime, String syncPk, int syncCount, String syncStatus) {
        SyncConfImpl syncConf=new SyncConfImpl();
        syncConf.setSyncId(syncId);
        syncConf.setSyncTime(syncTime);
        syncConf.setSyncPk(syncPk);
        syncConf.setSyncCount(syncCount);
        syncConf.setSyncStatus(syncStatus);
        syncConf.setTaskTime(LocalDateTime.now());
        syncConf.setVer(ver);

        BaseResult<Long> baseResult = messageHubSyncCnfApi.put(syncConf);
        if (baseResult==null || baseResult.getIsError()) {
            throw new RuntimeException("cannot upset sync status");
        }

        return baseResult.getData();

    }

    @Override
    public Stream.DBEntrySupplier.SyncConf syncConf(String syncId) {
        BaseResult<SyncConfImpl> baseResult = messageHubSyncCnfApi.get(syncId);
        if (baseResult==null || baseResult.getIsError() || baseResult.getData()==null) {
            return null;
        }
        return baseResult.getData();
    }

}
