package com.ovopark.messagehub.sdk.internal;


import com.ovopark.messagehub.sdk.model.internal.SyncConfImpl;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface MessageHubSyncCnfApi {

    @GetMapping("/messagehub-control/feign/sync-job/cfg/get")
    BaseResult<SyncConfImpl> get(@RequestParam("syncId") String syncId );

    @PostMapping("/messagehub-control/feign/sync-job/cfg/put")
    BaseResult<Long> put(@RequestBody SyncConfImpl syncConf);

}
