package com.ovopark.messagehub.sdk.internal;


import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "messagehub-plugins"
//        ,url = "127.0.0.1:13710"
)
public interface MessageHubPluginsApi {

    @PostMapping("/messagehub-plugins/rate/upset")
    BaseResult<Boolean> upsetRate(@RequestParam("subs") Subs subs, @RequestParam("ratePerSec") int ratePerSec);


    @PostMapping("/messagehub-plugins/thirdMessage/deleteDdMessage")
    public BaseResult<Boolean> deleteDdMessage(@RequestParam("groupId") Integer groupId, @RequestParam("dDMessageId") String dDMessageId);

    @PostMapping("/messagehub-plugins/thirdMessage/deleteFeishuMessage")
    public BaseResult<Boolean> deleteFeishuMessage(@RequestParam("groupId") Integer groupId, @RequestParam("feishuMessageId") String feishuMessageId);


    @PostMapping("/messagehub-plugins/thirdMessage/deleteQwMessage")
    public BaseResult<Boolean> deleteQwMessage(@RequestParam("groupId") Integer groupId, @RequestParam("messageId") String messageId);

    @PostMapping("/messagehub-plugins/thirdMessage/getMessageUrl")
    public BaseResult<String> getMessageUrl(@RequestBody ThirdMessage thirdMessage);

    @PostMapping("/messagehub-plugins/jg/registerDeviceAlias")
    public BaseResult<Boolean> registerDeviceAlias(@RequestParam("registrationId") String registrationId
            , @RequestParam("alias") String alias
            , @RequestParam("appKey") String appKey);

    @PostMapping("/messagehub-plugins/jg/tdr/push")
    public BaseResult<Boolean> tdrPush(@RequestBody PushNotificationParameter param);
}
