package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.migrate.MessageClassifyPo;
import com.ovopark.messagehub.sdk.model.migrate.SimpleCountVo;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@FeignClient(value = "messagehub-manage"
//        ,url = "127.0.0.1:13700"
)
public interface TodoMessageManageMigrateApi {

    /**
     * @description: 获取待办消息列表
     * @param: [pageSize, pageNumber, categories, isExecutor, sort, endTimeStart, endTimeEnd]
     * @return: com.ovopark.module.shared.BaseResult<java.util.Map < java.lang.String, java.lang.Object>>
     * @author wxb
     * @date: 2024/8/13 9:27
     */
    @GetMapping("/messagehub-manage/todoMessage/getTodoMessages")
    BaseResult<Map<String, Object>> getTodoMessages(@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                    @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
                                                    @RequestParam(value = "categories", required = false) String categories,
                                                    @RequestParam(value = "isExecutor", required = false) Integer isExecutor,
                                                    @RequestParam(value = "sort", defaultValue = "asc") String sort,
                                                    @RequestParam(value = "endTimeStart", required = false) String endTimeStart,
                                                    @RequestParam(value = "endTimeEnd", required = false) String endTimeEnd);

    /**
     * @description: 删除待办消息，只有已过期的待办消息允许删除
     * @param: [messageId]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/13 9:27
     */
    @PostMapping("/messagehub-manage/todoMessage/deleteTodoMessage")
    public BaseResult<Boolean> deleteTodoMessage(@RequestParam(value = "messageId")Long messageId);

    /**
     * @description: 批量删除待办消息，只有已过期的待办消息允许删除
     * @param: [messageIds]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/13 9:28
     */
    @PostMapping("/messagehub-manage/todoMessage/batchDeleteTodoMessages")
    public BaseResult<Boolean> batchDeleteTodoMessages(@RequestParam(value = "messageIds")String messageIds);

    /**
     * @description: 订阅待办模块
     * @param: [categories]
     * @return: com.ovopark.organize.common.base.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @PostMapping("/messagehub-manage/todoMessage/saveTodoMessageModules")
    public BaseResult<Boolean> saveTodoMessageModules(@RequestParam(value = "categories")String categories);

    /**
     * @description: 获取用户订阅的待办模块
     * @param: []
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.List < com.ovopark.messagehub.kernel.model.vo.SimpleCountVo>>
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @GetMapping("/messagehub-manage/todoMessage/getTodoMessageModules")
    public BaseResult<List<SimpleCountVo>> getTodoMessageModules();

    /**
     * @description: 获取用户订阅的待办模块（开放平台调用）
     * @param: [userId, loginName, mobilePhone, employeeName]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @GetMapping("/messagehub-manage/todoMessage/getUserTodoMessageModules")
    public BaseResult getUserTodoMessageModules(@RequestParam(value = "userId", required = false) Integer userId,
                                                @RequestParam(value = "loginName", required = false) String loginName,
                                                @RequestParam(value = "mobilePhone", required = false) String mobilePhone,
                                                @RequestParam(value = "employeeName", required = false) String employeeName);

    /**
     * @description: 获取所有待办模块
     * @param: []
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.List < com.ovopark.messagehub.kernel.model.vo.SimpleCountVo>>
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @GetMapping("/messagehub-manage/todoMessage/getAllTodoMessageModules")
    public BaseResult<List<SimpleCountVo>> getAllTodoMessageModules();

    /**
     * @description: 获取待办消息数量，按不同状态分类
     * @param: [category]
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.List < com.ovopark.messagehub.kernel.model.vo.SimpleCountVo>>
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @GetMapping("/messagehub-manage/todoMessage/getTodoMessageStatusCount")
    public BaseResult<List<SimpleCountVo>> getTodoMessageStatusCount(@RequestParam(value = "category", required = false) String category);

    /**
     * @description: 分别获取待办消息数量，和消息数量
     * @param: []
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.List < com.ovopark.messagehub.kernel.model.vo.SimpleCountVo>>
     * @author wxb
     * @date: 2024/8/8 15:25
     */
    @GetMapping("/messagehub-manage/todoMessage/getMessageCount")
    public BaseResult<List<SimpleCountVo>> getMessageCount();

    /**
     * @description: 获取未读消息列表
     * @param: [pageSize, pageNumber, status, objectType, noNeedType]
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.List < com.ovopark.messagehub.kernel.model.entity.Message>>
     * @author wxb
     * @date: 2024/8/8 15:24
     */
    @PostMapping("/messagehub-manage/todoMessage/getMyMessages")
    public BaseResult getMyMessages(@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                     @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
                                                     @RequestParam(value = "status", defaultValue = "-1") Integer status,
                                                     @RequestParam(value = "objectType", defaultValue = "") String objectType,
                                                     @RequestParam(value = "noNeedType", defaultValue = "") String noNeedType);

    /**
     * @description: 用户未读的消息（按大类进行分组）
     * @param: [flag]
     * @return: com.ovopark.module.shared.BaseResult<java.util.List < com.ovopark.messagehub.sdk.model.migrate.MessageClassifyPo>>
     * @author wxb
     * @date: 2024/8/13 9:30
     */
    @RequestMapping("/messagehub-manage/todoMessage/getUndoneMessageClassify")
    public BaseResult<List<MessageClassifyPo>> getUndoneMessageClassify(@RequestParam(value = "flag", required = false) Integer flag);

    /**
     * @description: 消息置为已读
     * @param: [category, objectType]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:24
     */
    @PostMapping("/messagehub-manage/todoMessage/changeAllMsgStauts")
    public BaseResult changeAllMsgStauts(@RequestParam(value = "category", required = false) String category,
                                         @RequestParam(value = "objectType", required = false) String objectType);

    /**
     * @description: 修改消息表消息状态
     * @param: [msgId]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:24
     */
    @RequestMapping("/messagehub-manage/todoMessage/updateMessage")
    public BaseResult updateMessage(@RequestParam(value = "msgId") Integer msgId);

    /**
     * @description: 批量修改消息状态
     * @param: [ids]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:24
     */
    @PostMapping("/messagehub-manage/todoMessage/updateMessageBatch")
    public BaseResult updateMessageBatch(@RequestBody List<Integer> ids);

    /**
     * @description: 批量删除消息
     * @param: [ids]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:24
     */
    @PostMapping("/messagehub-manage/todoMessage/deleteMessages")
    public BaseResult deleteMessages(@RequestBody List<Integer> ids);

    /**
     * @description: 按分类查询用户未读信息
     * @param: [index, num, objectType, category]
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.Map < java.lang.String, java.lang.Object>>
     * @author wxb
     * @date: 2024/8/8 15:23
     */
    @RequestMapping("/messagehub-manage/todoMessage/getUndoneMessageByClassify")
    public BaseResult<Map<String, Object>> getUndoneMessageByClassify(@RequestParam(value = "index")Integer index, @RequestParam(value = "num")Integer num
            , @RequestParam(value = "objectType")String objectType, @RequestParam(value = "category")String category);

    /**
     * @description: 获取最后一条未处理消息(APP首页用)
     * @param: [objectType]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:23
     */
    @GetMapping("/messagehub-manage/todoMessage/getLastMessage")
    public BaseResult getLastMessage(@RequestParam(value = "objectType", required = false) String objectType);

    /**
     * @description: 获取未处理消息列表(APP用)
     * @param: [objectType, pageNumber, pageSize]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:23
     */
    @GetMapping("/messagehub-manage/todoMessage/getUndoneMessages")
    public BaseResult getUndoneMessages(@RequestParam(value = "objectType", required = false) String objectType,
                                        @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
                                        @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * @description: 删除消息表消息状态
     * @param: [msgId]
     * @return: com.ovopark.organize.common.base.BaseResult
     * @author wxb
     * @date: 2024/8/8 15:23
     */
    @RequestMapping("/messagehub-manage/todoMessage/delMessage")
    public BaseResult delMessage(@RequestParam(value = "msgId")Integer msgId);

    /**
     * @description: 获取各消息大类需要的权限
     * @param: []
     * @return: com.ovopark.organize.common.base.BaseResult<java.util.Map < java.lang.String, java.lang.String>>
     * @author wxb
     * @date: 2024/8/8 15:23
     */
    @GetMapping(value = "/messagehub-manage/todoMessage/getMessagePrivilege")
    public BaseResult<Map<String, String>> getMessagePrivilege();

//    /**
//     * @description: 用户未读的消息（按小类进行分组）(计划巡店)
//     * @param: [req]
//     * @return: com.ovopark.shopweb.resp.JsonNewResult<java.util.List < com.ovopark.shopweb.resp.store.MessageObjectTypeResp>>
//     * @author wxb
//     * @date: 2024/8/8 15:22
//     */
//    @RequestMapping("/messagehub-manage/todoMessage/getUndoneMessageObjectType")
//    public JsonNewResult<List<MessageObjectTypeResp>> getUndoneMessageObjectType(@RequestBody MessageObjectReq req);

    /**
     * @description: 消息列表获取未读消息(计划巡店)
     * @param: [page, pageSize, objectType]
     * @return: com.ovopark.organize.common.base.BaseResult<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.ovopark.messagehub.kernel.model.pojo.StorePlanMessageBo>>
     * @author wxb
     * @date: 2024/8/8 15:22
     */
    @RequestMapping(value = "/messagehub-manage/todoMessage/getUnDoStorePlanMsg")
    public BaseResult getUnDoStorePlanMsg(@RequestParam(required = false) Integer page
            , @RequestParam(required = false) Integer pageSize
            , @RequestParam(required = false) String objectType);


}
