package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.ThirdMessage;
import com.ovopark.messagehub.sdk.model.kafka.UserMessageModel;
import com.ovopark.module.shared.BaseResult;
import lombok.Data;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Function;

import static com.ovopark.kernel.shared.Util.isEmpty;

public interface Send2ThirdProcessor {

    void send(UserMessageContext userMessageContext);


    interface UserMessageContext extends Stream.MsgPerContext {


        static UserMessageContext from(UserMessageModel userMessageModel){
            return new SimpleUserMessageContext(isEmpty(userMessageModel.getTraceId())?userMessageModel.getId():userMessageModel.getTraceId()
                    ,userMessageModel);
        }


        UserMessageModel message();

        TypeTmp typeTmp();

        /**
         * text link in third app , such dd, feishu ,qiwei
         * @return
         */
        String messageUrl();

        /**
         * h5, web link
         * @return
         */
        String messageOAuthUrl();

        @Slf4j
        class SimpleUserMessageContext extends Stream.MsgPerContextImpl implements UserMessageContext{

            final UserMessageModel userMessage;

            final private PerLogger perLogger=new PerLogger() {};

            @Setter
            MessageHubV2Api messageHubV2Api;

            @Setter
            private TypeTmp typeTmp;

            private SimpleUserMessageContext(String seq, UserMessageModel userMessage) {
                super(seq, null);
                this.userMessage = userMessage;
            }


            @Override
            public PerLogger logger() {
                return perLogger;
            }

            @Override
            public UserMessageModel message() {
                return userMessage;
            }

            @Override
            public TypeTmp typeTmp() {
                return typeTmp;
            }

            @Override
            public String messageUrl() {
                ThirdMessage thirdMessage = userMessage.getThirdMessage();
                if (thirdMessage==null) {
                    return null;
                }
                Value<String> value=setAttrIfAbsentAndGet("SimpleUserMessageContext:messageUrl", new Function<String, Value<String>>() {
                    @Override
                    public Value<String> apply(String s) {
                        BaseResult<String> baseResult = messageHubV2Api.getMessageUrl(thirdMessage);
                        logger().info(log,"request redirect url result: "+ JSONAccessor.impl().format(baseResult));
                        if (baseResult!= null && !baseResult.getIsError()) {
                            return new Value<>(baseResult.getData());
                        }
                        return new Value<>(null);
                    }
                });
                return value.ref;
            }

            @Override
            public String messageOAuthUrl() {
                Value<String> value=setAttrIfAbsentAndGet("SimpleUserMessageContext:messageOAuthUrl", new Function<String, Value<String>>() {
                    @Override
                    public Value<String> apply(String s) {
                        BaseResult<String> baseResult = messageHubV2Api.getMessageOAuthUrl(userMessage);
                        logger().info(log,"request redirect url result: "+ JSONAccessor.impl().format(baseResult));
                        if (baseResult!= null && !baseResult.getIsError()) {
                            return new Value<>(baseResult.getData());
                        }
                        return new Value<>(null);
                    }
                });
                return value.ref;
            }
        }

        @Data
        class TypeTmp{

            private String sourceModule;

            private boolean breakProcess;


        }

        @Data
        class Value<T>{

            final T ref;

            public Value(T ref) {
                this.ref = ref;
            }
        }

    }


}
