/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk;

import com.ovopark.messagehub.sdk.model.MessageModel;
import com.ovopark.messagehub.sdk.model.migrate.MessageClassifyPo;
import com.ovopark.messagehub.sdk.model.migrate.SDKMessageQuery;
import com.ovopark.module.shared.BaseResult;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="messagehub-control")
public interface MessageMigrateApi {
    @PostMapping(value={"/messagehub-control/feign/message/migrate/queryAll"})
    public BaseResult<List<MessageModel>> queryAll(@RequestBody SDKMessageQuery var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/searchOnce"})
    public BaseResult<List<MessageModel>> searchOnce(@RequestBody SDKMessageQuery var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/delete"})
    public BaseResult<List<String>> delete(@RequestBody List<String> var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/deleteAndSendWBS"})
    public BaseResult<Boolean> deleteAndSendWBS(@RequestBody SDKMessageQuery var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/updateMessage"})
    public BaseResult<Boolean> updateMessage(@RequestBody List<MessageModel> var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/getMsgCount"})
    public BaseResult<Long> getMsgCount(@RequestParam(value="objectType") String var1, @RequestParam(value="userId") Integer var2, @RequestParam(value="readFlag") int var3);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/getUndoneMessage"})
    public BaseResult<List<MessageClassifyPo>> getUndoneMessage(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/getUndoneMessageByType"})
    public BaseResult<List<MessageClassifyPo>> getUndoneMessageByType(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="objectTypeList") List<String> var3);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/getUnDoStorePlanMsg"})
    public BaseResult<List<MessageModel>> getUnDoStorePlanMsg(@RequestBody SDKMessageQuery var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/updateReadFlagNumId"})
    public BaseResult<Boolean> updateReadFlagNumId(@RequestParam(value="numId") Long var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/updateReadFlag"})
    public BaseResult<Boolean> updateReadFlag(@RequestParam(value="userId") Integer var1, @RequestParam(value="groupId") Integer var2, @RequestParam(value="category") String var3, @RequestParam(value="objectType") String var4);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/deleteNumId"})
    public BaseResult<Boolean> deleteNumId(@RequestBody List<Integer> var1);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/getUndoneMessageByClassify"})
    public BaseResult<List<MessageModel>> getUndoneMessageByClassify(@RequestBody SDKMessageQuery var1);

    @GetMapping(value={"/messagehub-control/feign/message/migrate/getMessageByNumId"})
    public BaseResult<MessageModel> getMessageByNumId(@RequestParam(value="numId") Long var1);

    @GetMapping(value={"/messagehub-control/feign/message/migrate/getMessagesByObjPage"})
    public BaseResult<List<MessageModel>> getMessagesByObjPage(@RequestParam(value="objectType") String var1, @RequestParam(value="objectId", required=false) Long var2, @RequestParam(value="userId") Integer var3, @RequestParam(value="pageNumber") long var4, @RequestParam(value="pageSize") int var6);

    @PostMapping(value={"/messagehub-control/feign/message/migrate/deleteMessageByNumId"})
    public BaseResult<Boolean> deleteMessageByNumId(@RequestParam(value="numId") Long var1);

    public static String ruleId(String category, String objectType) {
        if ("TYPE_FORM_CLOUD".equals(category)) {
            return "TYPE_FORM_CLOUD_MCXXX";
        }
        return objectType;
    }
}

