/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.sdk;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.TodoMsgTagService;
import com.ovopark.messagehub.sdk.model.TodoMessageTagGetRequest;
import com.ovopark.messagehub.sdk.model.TodoMessageTagGetResponse;
import com.ovopark.messagehub.sdk.model.TodoMessageTagSaveRequest;
import com.ovopark.module.shared.BaseResult;
import java.util.concurrent.TimeUnit;

class SimpleTodoMsgTagService
implements TodoMsgTagService {
    final TodoMessageV2Api todoMessageV2Api;
    static final KVEngine.TtlFunc<String> ttlFunc = KVEngine.newTtl((String)SimpleTodoMsgTagService.class.getName());

    public SimpleTodoMsgTagService(TodoMessageV2Api todoMessageV2Api) {
        this.todoMessageV2Api = todoMessageV2Api;
    }

    @Override
    public String get(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        String c = SimpleTodoMsgTagService.orderStr(category, objectType, targetUserId, objectId, others);
        String md5 = Util.md5((String)c);
        KVEngine.PutResult putResult = ttlFunc.putIfAbsentAndGet((Comparable)((Object)md5), s -> {
            TodoMessageTagGetRequest todoMessageTagGetRequest = new TodoMessageTagGetRequest();
            todoMessageTagGetRequest.setMd5(md5);
            BaseResult<TodoMessageTagGetResponse> baseResult = this.todoMessageV2Api.getTag(todoMessageTagGetRequest);
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null || !((TodoMessageTagGetResponse)baseResult.getData()).isSuccess()) {
                throw new IllegalArgumentException("cannot get tag(" + md5 + "): " + c);
            }
            String tag = ((TodoMessageTagGetResponse)baseResult.getData()).getTag();
            if (Util.isEmpty((CharSequence)tag)) {
                throw new IllegalArgumentException("cannot get tag(" + md5 + "): " + c);
            }
            return tag;
        }, 60L, TimeUnit.MINUTES);
        return (String)putResult.value();
    }

    private static String orderStr(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        String c = category + "|" + objectType + "|" + targetUserId + "|" + objectId;
        if (others != null) {
            for (String o : others) {
                c = c + "|" + o;
            }
        }
        return c;
    }

    @Override
    public String upsert(String category, String objectType, Integer targetUserId, Long objectId, String[] others, String content) {
        String c = SimpleTodoMsgTagService.orderStr(category, objectType, targetUserId, objectId, others);
        String md5 = Util.md5((String)c);
        String finalC = c;
        KVEngine.PutResult putResult = ttlFunc.putIfAbsentAndGet((Comparable)((Object)md5), s -> {
            TodoMessageTagGetRequest todoMessageTagGetRequest = new TodoMessageTagGetRequest();
            todoMessageTagGetRequest.setMd5(md5);
            BaseResult<TodoMessageTagGetResponse> baseResult = this.todoMessageV2Api.getTag(todoMessageTagGetRequest);
            if (baseResult == null || baseResult.getIsError().booleanValue() || baseResult.getData() == null || !((TodoMessageTagGetResponse)baseResult.getData()).isSuccess()) {
                throw new IllegalArgumentException("cannot get tag(" + md5 + "): " + finalC);
            }
            String tag = ((TodoMessageTagGetResponse)baseResult.getData()).getTag();
            if (Util.isEmpty((CharSequence)tag)) {
                TodoMessageTagSaveRequest todoMessageTagSaveRequest = new TodoMessageTagSaveRequest();
                todoMessageTagSaveRequest.setMd5(md5);
                todoMessageTagSaveRequest.setContent(content);
                BaseResult<TodoMessageTagGetResponse> b = this.todoMessageV2Api.upsertTag(todoMessageTagSaveRequest);
                if (b == null || b.getIsError().booleanValue() || b.getData() == null || !((TodoMessageTagGetResponse)b.getData()).isSuccess()) {
                    throw new IllegalArgumentException("cannot get tag(" + md5 + "): " + finalC);
                }
                tag = ((TodoMessageTagGetResponse)b.getData()).getTag();
                if (Util.isEmpty((CharSequence)tag)) {
                    throw new IllegalArgumentException("cannot get tag(" + md5 + "): " + finalC);
                }
            }
            return tag;
        }, 60L, TimeUnit.MINUTES);
        return (String)putResult.value();
    }
}

