package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.migrate.*;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@FeignClient(value = "messagehub-manage"
//        ,url = "127.0.0.1:13710"
)
public interface MessageHubManageApi {

    @PostMapping("/messagehub-manage/feign/findUnreadMessageByObj")
    BaseResult<List<MessageMo>> findUnreadMessageByObj(@RequestParam("objectType") String objectType, @RequestParam("targetUserId") Integer targetUserId,
                                                       @RequestParam("index") Integer index, @RequestParam("num") Integer num);

    @PostMapping("/messagehub-manage/feign/findUnreadMessageByObjTotalCount")
    BaseResult<Long> findUnreadMessageByObjTotalCount(@RequestParam("objectType") String objectType, @RequestParam("targetUserId") Integer targetUserId);

    @PostMapping("/messagehub-manage/feign/deleteMessagesByObject")
    BaseResult<Boolean> deleteMessagesByObject(@RequestParam("objectType") String objectType,
                                                      @RequestParam(value = "objectId", required = false) Integer objectId,
                                                      @RequestParam(value = "objectIds", required = false) String objectIds,
                                                      @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                      @RequestParam(value = "subId", required = false) Integer subId,
                                                      @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage,
                                                      @RequestParam(value = "srcUserId", required = false) Integer srcUserId);

    @PostMapping("/messagehub-manage/feign/updateMessagesByObjectType")
    BaseResult<Boolean> updateMessagesByObjectType(@RequestParam("objectType") String objectType,
                                                          @RequestParam(value = "objectId", required = false) Integer objectId,
                                                          @RequestParam(value = "objectIds", required = false) String objectIds,
                                                          @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                          @RequestParam(value = "subId", required = false) Integer subId,
                                                          @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage,
                                                          @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
                                                          @RequestParam(value = "content", required = false) String content,
                                                          @RequestParam(value = "endTime", required = false) String endTime);

    @PostMapping("/deleteMessagesByBatchObjectIds")
    BaseResult<Boolean> deleteMessagesByBatchObjectIds(@RequestParam("objectType") String objectType,
                                                              @RequestParam("objectIds") String objectIds,
                                                              @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                              @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage);

    @PostMapping("/deleteMessagesByCategoryAndObjectIds")
    BaseResult<Boolean> deleteMessagesByCategoryAndObjectIds(@RequestParam("category") String category,
                                                                    @RequestParam("objectIds") String objectIds,
                                                                    @RequestParam(value = "targetUserId", required = false) Integer targetUserId);

    @PostMapping("/deleteMessagesByObjectIdsAndType")
    BaseResult<Boolean> deleteMessagesByObjectIdsAndType(@RequestBody MeaasgeMo mo);

    @PostMapping("/saveMessages")
    BaseResult<Long> saveMessages(@RequestBody MessageMo messageMo);

    @RequestMapping("/saveBatch")
    BaseResult saveBatch(@RequestBody List<MessageMo> list);

    @PostMapping("/deleteMessagesByObjectAndWeixin")
    BaseResult<Boolean> deleteMessagesByObjectAndWeixin(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/isNotSendJPush")
    BaseResult<Boolean> isNotSendJPush(@RequestBody MeaasgeConfigureMo mo);

    @PostMapping("/saveBatchMessages")
    BaseResult<Boolean> saveBatchMessages(@RequestBody MessageBatchMo mo);

    @PostMapping("/setMessagesHistoryByObject")
    BaseResult<Boolean> setMessagesHistoryByObject(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/setMessagesStatusByObject")
    BaseResult<Boolean> setMessagesStatusByObject(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/getMessageByObjectTypeAndObjectId")
    BaseResult<List<MessageMo>> getMessageByObjectTypeAndObjectId(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/getNotSendUserId")
    BaseResult<List<Integer>> getNotSendUserId(@RequestBody Map<String, Object> param);

    @PostMapping("/getUndoneMessageByClassify")
    BaseResult<Map<String, Object>> getUndoneMessageByClassify(Integer userId, Integer groupId, String objectType,
                                                                      String category, String exceptObjectTypes);

    @PostMapping("/deleteMandatoryReminderMessage")
    BaseResult<Boolean> deleteMandatoryReminderMessage(@RequestBody MeaasgeAndWeixinMo mo);

    @GetMapping("/getTodoMessages")
    BaseResult<Map<String, Object>> getTodoMessages(@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(value = "categories", required = false) String categories,
                                                           @RequestParam(value = "isExecutor", required = false) Integer isExecutor,
                                                           @RequestParam(value = "sort", defaultValue = "asc") String sort,
                                                           @RequestParam(value = "endTimeStart", required = false) String endTimeStart,
                                                           @RequestParam(value = "endTimeEnd", required = false) String endTimeEnd);

    @PostMapping("/deleteTodoMessage")
    BaseResult<Boolean> deleteTodoMessage(Long messageId);

    @PostMapping("/batchDeleteTodoMessages")
    BaseResult<Boolean> batchDeleteTodoMessages(String messageIds);

    @PostMapping("/saveTodoMessageModules")
    BaseResult<Boolean> saveTodoMessageModules(String categories);

    @GetMapping("/getTodoMessageModules")
    BaseResult<List<SimpleCountVo>> getTodoMessageModules();

    @GetMapping("/getUserTodoMessageModules")
    BaseResult getUserTodoMessageModules(@RequestParam(value = "userId", required = false) Integer userId,
                                                @RequestParam(value = "loginName", required = false) String loginName,
                                                @RequestParam(value = "mobilePhone", required = false) String mobilePhone,
                                                @RequestParam(value = "employeeName", required = false) String employeeName);

    @GetMapping("/getAllTodoMessageModules")
    BaseResult<List<SimpleCountVo>> getAllTodoMessageModules();

    @GetMapping("/getTodoMessageStatusCount")
    BaseResult<List<SimpleCountVo>> getTodoMessageStatusCount(@RequestParam(value = "category", required = false) String category);

    @GetMapping("/getMessageCount")
    BaseResult<List<SimpleCountVo>> getMessageCount();

//    @PostMapping("/getMyMessages")
//    BaseResult<List<Message>> getMyMessages(@RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
//                                                   @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
//                                                   @RequestParam(value = "status", defaultValue = "-1") Integer status,
//                                                   @RequestParam(value = "objectType", defaultValue = "") String objectType,
//                                                   @RequestParam(value = "noNeedType", defaultValue = "") String noNeedType);

    @RequestMapping("/getUndoneMessageClassify")
    BaseResult<List<MessageClassifyPo>> getUndoneMessageClassify(@RequestParam(required = false) Integer flag);

    @PostMapping("/changeAllMsgStauts")
    BaseResult changeAllMsgStauts(@RequestParam(value = "category", required = false) String category,
                                         @RequestParam(value = "objectType", required = false) String objectType);

    @RequestMapping("/updateMessage")
    BaseResult updateMessage(@RequestParam(value = "msgId") Integer msgId);

    @PostMapping("/updateMessageBatch")
    BaseResult updateMessageBatch(@RequestBody List<Integer> ids);

    @PostMapping("/deleteMessages")
    BaseResult deleteMessages(@RequestBody List<Integer> ids);

    @RequestMapping("/getUndoneMessageByClassify")
    BaseResult<Map<String, Object>> getUndoneMessageByClassify(Integer index, Integer num, String objectType, String category);

    @GetMapping("/getLastMessage")
    BaseResult getLastMessage(@RequestParam(value = "objectType", required = false) String objectType);

    @GetMapping("/getUndoneMessages")
    BaseResult getUndoneMessages(@RequestParam(value = "objectType", required = false) String objectType,
                                        @RequestParam(value = "pageNumber", defaultValue = "1") Integer pageNumber,
                                        @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);

    @RequestMapping("/delMessage")
    BaseResult delMessage(Integer msgId);

    @PostMapping(value = "confirmValidationMessage")
    BaseResult confirmValidationMessage();

    @GetMapping(value = "getMessagePrivilege")
    BaseResult<Map<String, String>> getMessagePrivilege();

    @GetMapping(value = "showAdvertisements")
    BaseResult showAdvertisements(Integer adType, Integer enterpriseId, @RequestParam(value = "isNew", defaultValue = "1") Integer isNew);

    @GetMapping(value = "getAdvertisements")
    BaseResult getAdvertisements(Integer adType, @RequestParam(value = "isNew", defaultValue = "1") Integer isNew);

//    @RequestMapping("/getUndoneMessageObjectType")
//    JsonNewResult<List<MessageObjectTypeResp>> getUndoneMessageObjectType(@RequestBody MessageObjectReq req);
//
//    @RequestMapping(value = "/getUnDoStorePlanMsg")
//    BaseResult<Page<StorePlanMessageBo>> getUnDoStorePlanMsg(@RequestParam(required = false) Integer page
//            , @RequestParam(required = false) Integer pageSize
//            , @RequestParam(required = false) String objectType);
//
//    @RequestMapping("/getUndoneMandatoryReminderMessage")
//    BaseResult<List<MandatoryReminderMessage>> getUndoneMandatoryReminderMessage(@RequestParam(value = "objectType", required = false) String objectType);

    @RequestMapping("/updateMandatoryReminderMessageStatu")
    BaseResult updateMandatoryReminderMessageStatu(@RequestBody List<Integer> reminderIds);

}
