package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.*;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import com.ovopark.messagehub.sdk.model.internal.GroupCfg;
import com.ovopark.messagehub.sdk.model.kafka.UserMessageModel;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface MessageHubV2Api {

    @PostMapping("/messagehub-control/feign/message/render")
    BaseResult<String> render(@RequestBody RenderModel renderModel);

    @PostMapping("/messagehub-control/feign/message/send")
    BaseResult<String> send(@RequestBody MessageRequest messageRequest);


    @PostMapping("/messagehub-control/feign/message/bulkSend")
    BaseResult<MessageBulkResponse> bulkSend(@RequestBody MessageBulkRequest messageBulkRequest);

    @PostMapping("/messagehub-control/feign/message/saveMCSync")
    BaseResult<MCRequestResponse> saveMCSync(@RequestBody MCRequest mcRequest);

    @PostMapping("/messagehub-control/feign/message/saveMCAsync")
    BaseResult<String> saveMCAsync(@RequestBody MCRequest mcRequest);

    @GetMapping("/messagehub-control/feign/message/countMsg")
    BaseResult<Long> countMsg(
            @RequestParam("userId") Integer userId
            , @RequestParam("groupId") Integer groupId
            ,@RequestParam("msgTypeCodeList") List<String> msgTypeCodeList
            , @RequestParam("readFlag") Integer readFlag);

    @PostMapping("/messagehub-control/feign/message/resendOneMsg")
    BaseResult<String> resendOneMsg(
            @RequestParam("msgId") String msgId
            ,@RequestParam("subsList") List<Subs> subsList);

    @PostMapping("/messagehub-control/feign/message/resendMsgTask")
    BaseResult<String> resendMsgTask(@RequestParam("taskId") String taskId
            ,@RequestParam("subsList") List<Subs> subsList
            ,@RequestParam(value = "userId",required = false) Integer userId
            ,@RequestParam(value = "mail",required = false) String mail);

    @Deprecated
    @PostMapping("/messagehub-control/feign/message/deleteAndSendWBS/v1")
    BaseResult<Boolean> deleteAndSendWBSV1(@RequestParam(value = "userId",required = false) Integer userId
            , @RequestParam(value = "msgTypeCodeList") List<String> msgTypeCodeList
            , @RequestParam(value = "objectId") Long objectId);


    @PostMapping("/messagehub-control/feign/message/deleteMsgAndRefMsg/v1")
    public BaseResult<Boolean> deleteMsgAndRefMsg(@RequestParam(value = "userId",required = true) Integer userId
            , @RequestParam(value = "msgTypeCodeList",required = true) List<String> msgTypeCodeList
            , @RequestParam(value = "objectId",required = false) Long objectId
            , @RequestParam(value = "subId",required = false) Long subId);

    @PostMapping("/messagehub-control/feign/message/deleteMsgAndRefMsg/v2")
    public BaseResult<Boolean> deleteMsgAndRefMsg(@RequestParam(value = "userId") Integer userId
            , @RequestParam(value = "msgTypeCodeList") List<String> msgTypeCodeList
            , @RequestParam(value = "refId") String refId);

    @GetMapping("/messagehub-control/feign/message/getMessageByRefId")
    BaseResult<MessageResponse> getMessageByRefId(@RequestParam(value = "userId") Integer userId
            , @RequestParam(value = "msgTypeCodeList") List<String> msgTypeCodeList
            , @RequestParam(value = "refId") String refId
            , @RequestParam(value = "delFlag",required = false) Integer delFlag);


    @GetMapping("/messagehub-control/feign/message/cron/getCronTaskId")
    BaseResult<Long> getCronTaskId(@RequestParam("msgTraceId") String msgTraceId);

    @PostMapping("/messagehub-control/feign/message/cron/cancelByMsgTraceId")
    BaseResult<Boolean> cancelCronTask(@RequestParam("msgTraceId") String msgTraceId);

    @PostMapping("/messagehub-control/feign/message/cron/cancelById")
    BaseResult<Boolean> cancelCronTask(@RequestParam("id") long id);

    @GetMapping("/messagehub-control/feign/message/getMessageByTodoMsgId")
    BaseResult<MessageResponse> getMessageByTodoMsgId(@RequestParam(value = "todoMsgId") long todoMsgId);

    @PostMapping("/messagehub-control/feign/message/deleteThirdMsg")
    BaseResult<String> deleteThirdMsg(@RequestParam(name = "msgId") String msgId
            ,@RequestParam(name = "subsList") List<Subs> subsList);

    @PostMapping("/messagehub-control/feign/message/deleteThirdMsgByTodoMsgId")
    BaseResult<String> deleteThirdMsgByTodoMsgId(@RequestParam(value = "todoMsgId") long todoMsgId
            ,@RequestParam(name = "subsList") List<Subs> subsList);

    @PostMapping("/messagehub-control/feign/message/deleteMsgAndRefMsg")
    public BaseResult<Boolean> deleteMsgAndRefMsg(@RequestParam(value = "msgId",required = true) String msgId);

    @PostMapping("/messagehub-control/feign/message/jg/registerDeviceAlias")
    public BaseResult<Boolean> registerDeviceAlias(@RequestParam("registrationId") String registrationId
            , @RequestParam("alias") String alias
            , @RequestParam("appKey") String appKey);

    @PostMapping("/messagehub-control/feign/message/jg/tdr/push")
    public BaseResult<Boolean> tdrPush(@RequestBody PushNotificationParameter param);

    @PostMapping("/messagehub-control/feign/message/moveMsg")
    public BaseResult<Boolean> moveMsg(@RequestParam(value = "fromUserIdList") List<Integer> fromUserIdList
            ,@RequestParam(value = "toUserId") Integer toUserId
            ,@RequestParam(value = "msgTypeCodeList",required = true) List<String> msgTypeCodeList
    );

    @PostMapping("/messagehub-control/feign/message/link/getMessageUrl")
    public BaseResult<String> getMessageUrl(@RequestBody ThirdMessage thirdMessage);

    @PostMapping("/messagehub-control/feign/message/link/getMessageOAuthUrl")
    public BaseResult<String> getMessageOAuthUrl(@RequestBody UserMessageModel userMessageModel);

    @PostMapping("/messagehub-control/feign/message/sendSMSSync")
    BaseResult<SMSSendResponse> sendSMSSync(@RequestBody MessageRequest messageRequest);

    @PostMapping("/messagehub-control/feign/message/tdr/tdrSendSMSSync")
    BaseResult<SMSSendResponse> tdrSendSMSSync(@RequestBody MessageRequest messageRequest);

    @PostMapping("/messagehub-control/feign/message/inst/instSendSMSSync")
    BaseResult<SMSSendResponse> instSendSMSSync(@RequestBody MessageRequest messageRequest);

    @PostMapping("/messagehub-control/feign/message/openApi/openApiSendSMSSync")
    BaseResult<SMSSendResponse> openApiSendSMSSync(@RequestBody MessageRequest messageRequest);

    @GetMapping("/messagehub-control/feign/message/groupConfig")
    BaseResult<GroupCfg> groupConfig(@RequestParam("groupId") Integer groupId);

}
