package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.migrate.MeaasgeAndWeixinMo;
import com.ovopark.messagehub.sdk.model.migrate.MeaasgeMo;
import com.ovopark.messagehub.sdk.model.migrate.MessageBatchMo;
import com.ovopark.messagehub.sdk.model.migrate.MessageMo;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface TodoMessageControlMigrateApi {

    @PostMapping("/messagehub-control/feign/todoMessage/findUnreadMessageByObj")
    public BaseResult<List<MessageMo>> findUnreadMessageByObj(@RequestParam("objectType") String objectType, @RequestParam("targetUserId") Integer targetUserId,
                                                              @RequestParam("index") Integer index, @RequestParam("num") Integer num);

    @PostMapping("/messagehub-control/feign/todoMessage/findUnreadMessageByObjTotalCount")
    public BaseResult<Long> findUnreadMessageByObjTotalCount(@RequestParam("objectType") String objectType, @RequestParam("targetUserId") Integer targetUserId);

    /**
     * @description: 根据object删除消息
     * @param: [objectType, objectId, objectIds, targetUserId, subId, isTodoMessage, srcUserId]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:12
     */
    @PostMapping("/messagehub-control/feign/todoMessage/deleteMessagesByObject")
    public BaseResult<Boolean> deleteMessagesByObject(@RequestParam("objectType") String objectType,
                                                      @RequestParam(value = "objectId", required = false) Integer objectId,
                                                      @RequestParam(value = "objectIds", required = false) String objectIds,
                                                      @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                      @RequestParam(value = "subId", required = false) Integer subId,
                                                      @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage,
                                                      @RequestParam(value = "srcUserId", required = false) Integer srcUserId);

    /**
     * @description: 根据object修改消息
     * @param: [objectType, objectId, objectIds, targetUserId, subId, isTodoMessage, srcUserId, content, endTime]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:13
     */
    @PostMapping("/messagehub-control/feign/todoMessage/updateMessagesByObjectType")
    public BaseResult<Boolean> updateMessagesByObjectType(@RequestParam("objectType") String objectType,
                                                          @RequestParam(value = "objectId", required = false) Integer objectId,
                                                          @RequestParam(value = "objectIds", required = false) String objectIds,
                                                          @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                          @RequestParam(value = "subId", required = false) Integer subId,
                                                          @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage,
                                                          @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
                                                          @RequestParam(value = "content", required = false) String content,
                                                          @RequestParam(value = "endTime", required = false) String endTime);

    /**
     * @description: 根据object删除消息
     * @param: [objectType, objectIds, targetUserId, isTodoMessage]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:13
     */
    @PostMapping("/messagehub-control/feign/todoMessage/deleteMessagesByBatchObjectIds")
    public BaseResult<Boolean> deleteMessagesByBatchObjectIds(@RequestParam("objectType") String objectType,
                                                              @RequestParam("objectIds") String objectIds,
                                                              @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
                                                              @RequestParam(value = "isTodoMessage", defaultValue = "1") Integer isTodoMessage);

    /**
     * @description: 根据category和objectId删除消息（CRM专用）
     * @param: [category, objectIds, targetUserId]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:16
     */
    @PostMapping("/messagehub-control/feign/todoMessage/deleteMessagesByCategoryAndObjectIds")
    public BaseResult<Boolean> deleteMessagesByCategoryAndObjectIds(@RequestParam("category") String category,
                                                                    @RequestParam("objectIds") String objectIds,
                                                                    @RequestParam(value = "targetUserId", required = false) Integer targetUserId);

    @PostMapping("/messagehub-control/feign/todoMessage/deleteMessagesByObjectIdsAndType")
    public BaseResult<Boolean> deleteMessagesByObjectIdsAndType(@RequestBody MeaasgeMo mo);

    /**
     * @description: 保存消息
     * @param: [messageMo]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Long>
     * @author wxb
     * @date: 2024/8/8 14:17
     */
    @PostMapping("/messagehub-control/feign/todoMessage/saveMessages")
    public BaseResult<Long> saveMessages(@RequestBody MessageMo messageMo);

    /**
     * @description: 根据object删除消息 + 企业微信 消息发送（卡片类型）
     * @param: [mo]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:51
     */
    @PostMapping("/messagehub-control/feign/todoMessage/deleteMessagesByObjectAndWeixin")
    public BaseResult<Boolean> deleteMessagesByObjectAndWeixin(@RequestBody MeaasgeAndWeixinMo mo);

    /**
     * @description: 批量 给 人员 发送消息
     * @param: [mo]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:50
     */
    @PostMapping("/messagehub-control/feign/todoMessage/saveBatchMessages")
    BaseResult<Boolean> saveBatchMessages(@RequestBody MessageBatchMo mo);

    /**
     * @description: 批量更新消息状态 变成 已读 消息 更新到 其他表中 保存
     * @param: [mo]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/8/8 14:50
     */
    @PostMapping("/messagehub-control/feign/todoMessage/setMessagesHistoryByObject")
    BaseResult<Boolean> setMessagesHistoryByObject(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/messagehub-control/feign/todoMessage/setMessagesStatusByObject")
    BaseResult<Boolean> setMessagesStatusByObject(@RequestBody MeaasgeAndWeixinMo mo);

    @PostMapping("/messagehub-control/feign/todoMessage/getMessageByObjectTypeAndObjectId")
    BaseResult<List<MessageMo>> getMessageByObjectTypeAndObjectId(@RequestBody MeaasgeAndWeixinMo mo);

    /**
     * @description: 按分类查询用户未读信息
     * @param: [userId, groupId, objectType, category, exceptObjectTypes]
     * @return: com.ovopark.module.shared.BaseResult<java.util.Map < java.lang.String, java.lang.Object>>
     * @author wxb
     * @date: 2024/8/8 14:53
     */
    @PostMapping("/messagehub-control/feign/todoMessage/getUndoneMessageByClassify")
    public BaseResult<Map<String, Object>> getUndoneMessageByClassify(@RequestParam(value = "userId")Integer userId, @RequestParam(value = "groupId")Integer groupId, @RequestParam(value = "objectType")String objectType,
                                                                      @RequestParam(value = "category")String category, @RequestParam(value = "exceptObjectTypes")String exceptObjectTypes);


}
