package com.ovopark.messagehub.sdk;


import com.ovopark.messagehub.sdk.model.*;
import com.ovopark.messagehub.sdk.model.kafka.TodoMsgEvent;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface TodoMessageV2Api {

    @PostMapping("/messagehub-control/feign/todoMessage/V2/saveTodoMessage")
    BaseResult<TodoMessageSaveResponse> saveTodoMessage(@RequestBody OneTodoMessageSaveRequest oneTodoMessageSaveRequest);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/bulkSaveTodoMessage")
    BaseResult<TodoMessageBulkSaveResponse> bulkSaveTodoMessage(@RequestBody OneTodoMessageBulkSaveRequest oneTodoMessageBulkSaveRequest);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/completeTodoMessage")
    BaseResult<Boolean> completeTodoMessage(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/completeTodoMessageAndDelIfPossible")
    BaseResult<Boolean> completeTodoMessageAndDelIfPossible(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "completeUserIdList", required = false) List<Integer> completeUserIdList,
            @RequestParam(value = "deleteOtherUser") boolean deleteOtherUser,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/completeTodoMessageOnlyForPlan")
    BaseResult<Boolean> completeTodoMessageOnlyForPlan(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageOnlyForPlan")
    BaseResult<Boolean> deleteTodoMessageOnlyForPlan(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/completeTodoMessageOnlyForOA")
    BaseResult<Boolean> completeTodoMessageOnlyForOA(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectIdList", required = false) List<Integer> objectIdList,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageOnlyForOAIf4Optimize")
    BaseResult<Boolean> deleteTodoMessageOnlyForOAIf4Optimize(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectIdList", required = false) List<Integer> objectIdList,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag,
            @RequestParam(value = "createTimeSecIf4Optimize", required = false) Long createTimeSecIf4Optimize
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessage")
    BaseResult<Boolean> deleteTodoMessage(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageIf4Optimize")
    BaseResult<Boolean> deleteTodoMessageIf4Optimize(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag,
            @RequestParam(value = "createTimeSecIf4Optimize", required = false) Long createTimeSecIf4Optimize
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageAndCompletedHistoryIf4Optimize")
    BaseResult<Boolean> deleteTodoMessageAndCompletedHistoryIf4Optimize(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) List<Integer> targetUserIdList,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag,
            @RequestParam(value = "deleteCompletedTodoMsgFlag") boolean deleteCompletedTodoMsgFlag,
            @RequestParam(value = "includeCompletedHistory") boolean includeCompletedHistory,
            @RequestParam(value = "createTimeSecIf4Optimize", required = false) Long createTimeSecIf4Optimize
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageAndCompletedHistoryIf4Optimize/postWithBody")
    BaseResult<Boolean> deleteTodoMessageAndCompletedHistoryIf4Optimize(@RequestBody TodoMsgFilter todoMsgFilter);


    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageOnlyForXunDian")
    BaseResult<Boolean> deleteTodoMessageOnlyForXunDian(@RequestBody TodoMsgFilter todoMsgFilter);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessageIf4OptimizeV2")
    BaseResult<Boolean> deleteTodoMessageIf4OptimizeV2(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "deleteMsgFlag") boolean deleteMsgFlag,
            @RequestParam(value = "createTimeSecIf4Optimize", required = false) Long createTimeSecIf4Optimize,
            @RequestParam(value = "groupId", required = false) Integer groupId
    );


//    @GetMapping("/messagehub-control/feign/todoMessage/V2/getMessages")
//    BaseResult<TodoMessageGetResponse> getMessages(@RequestParam("objectType") String objectType
//            , @RequestParam(value = "objectId", required = false) Integer objectId);

//    @PostMapping("/messagehub-control/feign/todoMessage/V2/deleteTodoMessagesById")
//    BaseResult<Boolean> deleteTodoMessagesById(
//            @RequestParam(value = "id", required = true) Long id);

    /** 
     * @description: 根据object修改消息 updateMessagesByObjectType
     * @param: [objectType, objectId, objectIds, targetUserId, subId, srcUserId, content, endTime]
     * @return: com.ovopark.module.shared.BaseResult<java.lang.Boolean>
     * @author wxb
     * @date: 2024/9/9 13:38
     */ 
    @PostMapping("/messagehub-control/feign/todoMessage/V2/updateMessagesByObjectType")
    BaseResult<Boolean> updateMessagesByObjectType(
            @RequestParam("objectType") String objectType,
            @RequestParam(value = "objectId", required = false) Integer objectId,
            @RequestParam(value = "objectIds", required = false) String objectIds,
            @RequestParam(value = "targetUserId", required = false) Integer targetUserId,
            @RequestParam(value = "subId", required = false) Integer subId,
            @RequestParam(value = "srcUserId", required = false) Integer srcUserId,
            @RequestParam(value = "content", required = false) String content,
            @RequestParam(value = "endTime", required = false) String endTime);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/moveTodoMessage2OtherUser")
    public BaseResult<Boolean> moveTodoMessage2OtherUser(
            @RequestParam(value = "fromUserIdList") List<Integer> fromUserIdList
            ,@RequestParam(value = "toUserId") Integer toUserId
            ,@RequestParam(value = "categoryList",required = true) List<String> categoryList
    );

    @PostMapping("/messagehub-control/feign/todoMessage/V2/link/getTodoMsgUrl")
    BaseResult<String> getTodoMsgUrl(@RequestBody TodoMsgEvent todoMsgEvent);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/tag/get")
    BaseResult<TodoMessageTagGetResponse> getTag(@RequestBody TodoMessageTagGetRequest todoMessageTagGetRequest);

    @PostMapping("/messagehub-control/feign/todoMessage/V2/tag/upsert")
    BaseResult<TodoMessageTagGetResponse> upsertTag(@RequestBody TodoMessageTagSaveRequest todoMessageTagSaveRequest);
}
