package com.ovopark.messagehub.sdk.internal;


import com.ovopark.messagehub.sdk.model.internal.I18Data;
import com.ovopark.messagehub.sdk.model.internal.Node;
import com.ovopark.messagehub.sdk.model.internal.OffPopModel;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


@FeignClient(value = "messagehub-control"
//        ,url = "127.0.0.1:13700"
)
public interface MessageHubInternalApi {

    @PostMapping("/messagehub-control/feign/node/heartbeat")
    BaseResult<Boolean> heartbeat(@RequestBody Node node);

//    @PostMapping("/messagehub-control/feign/node/delay/get")
//    BaseResult<Map<String, NodeView>> getDelay();

//    @PostMapping("/messagehub-control/feign/message/notice")
//    BaseResult<Long> notice(@RequestBody NoticeModel noticeModel);

    @PostMapping("/messagehub-control/feign/message/offPop")
    BaseResult<Boolean> offPop(@RequestBody OffPopModel offPopModel);

    @GetMapping("/messagehub-control/feign/i18data/list")
    BaseResult<List<I18Data>> list();

    @PostMapping("/messagehub-control/feign/i18data/put")
    BaseResult<Boolean> put(@RequestBody List<I18Data> i18DataList);



}
