package com.ovopark.messagehub.sdk.msgstream;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.messagehub.sdk.TodoMessageV2Api;
import com.ovopark.messagehub.sdk.model.kafka.TodoMsgEvent;
import com.ovopark.module.shared.BaseResult;
import lombok.Data;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.function.Function;

import static com.ovopark.kernel.shared.Util.isEmpty;
import static com.ovopark.kernel.shared.Util.isNotEmpty;

public interface SendTodoMsg2ThirdProcessor {

    void send(TodoMsgEventContext todoMsgEventContext);


    interface TodoMsgEventContext extends Stream.MsgPerContext {

        static TodoMsgEventContext from(TodoMsgEvent todoMsgEvent){
            return new SimpleTodoMsgEventContext(isEmpty(todoMsgEvent.getTraceId())
                    ?todoMsgEvent.getOp()+"-"+todoMsgEvent.getTodoMsg().getId():todoMsgEvent.getTraceId()
                    ,todoMsgEvent);
        }


        TodoMsgEvent todoMsgEvent();

        String url();

        @Slf4j
        class SimpleTodoMsgEventContext extends Stream.MsgPerContextImpl implements TodoMsgEventContext{

            final TodoMsgEvent todoMsgEvent;

            final private PerLogger perLogger=new PerLogger() {};

            @Setter
            TodoMessageV2Api todoMessageV2Api;

            private SimpleTodoMsgEventContext(String seq, TodoMsgEvent todoMsgEvent) {
                super(seq, null);
                this.todoMsgEvent = todoMsgEvent;
            }


            @Override
            public PerLogger logger() {
                return perLogger;
            }

            @Override
            public TodoMsgEvent todoMsgEvent() {
                return todoMsgEvent;
            }

            @Override
            public String url() {

                if (todoMsgEvent==null) {
                    return null;
                }

                TodoMsgEvent.TodoMsg todoMsg = todoMsgEvent.getTodoMsg();
                String oauthUrl = todoMsg.getOauthUrl();
                if (isNotEmpty(oauthUrl)) {
                    return oauthUrl;
                }

                SimpleTodoMsgEventContext.Value<String> value=setAttrIfAbsentAndGet("SimpleTodoMsgEventContext:todoMsgUrl"
                        , new Function<String, SimpleTodoMsgEventContext.Value<String>>() {
                    @Override
                    public SimpleTodoMsgEventContext.Value<String> apply(String s) {
                        BaseResult<String> baseResult = todoMessageV2Api.getTodoMsgUrl(todoMsgEvent);
                        logger().info(log,"request url result: "+ JSONAccessor.impl().format(baseResult));
                        if (baseResult!= null && !baseResult.getIsError()) {
                            return new SimpleTodoMsgEventContext.Value<>(baseResult.getData());
                        }
                        return new SimpleTodoMsgEventContext.Value<>(null);
                    }
                });
                return value.ref;
            }

        }


        @Data
        class Value<T>{

            final T ref;

            public Value(T ref) {
                this.ref = ref;
            }
        }



    }


}
