package com.ovopark.messagehub.sdk;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringTodoMsgTagService implements TodoMsgTagService, ApplicationContextAware {

    ApplicationContext applicationContext;

    TodoMsgTagService todoMsgTagService;

    @Autowired(required = false)
    public void setTodoMessageV2Api(TodoMessageV2Api todoMessageV2Api) {
        todoMsgTagService = TodoMsgTagService.newService(todoMessageV2Api);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext=applicationContext;
    }

    @Override
    public String get(String category, String objectType, Integer targetUserId, Long objectId, String[] others) {
        setTagServiceIfAbsent();
        return todoMsgTagService.get(category, objectType, targetUserId, objectId, others);
    }

    @Override
    public String upsert(String category, String objectType, Integer targetUserId, Long objectId, String[] others, String content) {
        setTagServiceIfAbsent();
        return todoMsgTagService.upsert(category, objectType, targetUserId, objectId, others, content);
    }

    private void setTagServiceIfAbsent() {
        // todoMsgTagService is null???
        if (todoMsgTagService==null) {
            synchronized (applicationContext){
                if (todoMsgTagService!=null) {
                    return;
                }
                TodoMessageV2Api messageV2Api = applicationContext.getBean(TodoMessageV2Api.class);
                if (messageV2Api==null) {
                    throw new IllegalStateException("cannot construct service");
                }
                this.todoMsgTagService=TodoMsgTagService.newService(messageV2Api);
            }
        }
    }
}
